/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.builders.impl;

import be.cin.nip.async.generic.GetResponse;
import be.cin.nip.async.generic.MsgResponse;
import be.cin.nip.async.generic.PostResponse;
import be.cin.nip.async.generic.TAck;
import be.cin.nip.async.generic.TAckResponse;
import be.ehealth.businessconnector.genericasync.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorException;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.genericasync.exception.GenAsyncSignatureValidationConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseObjectBuilderImpl
implements ResponseObjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseObjectBuilderImpl.class);

    @Override
    public final boolean handlePostResponse(PostResponse postResponse) throws GenAsyncBusinessConnectorException {
        if (postResponse == null || postResponse.getReturn() == null) {
            throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.PARAMETER_NULL, "the postResponse or postResponse.return was null");
        }
        TAck tack = postResponse.getReturn();
        if (!tack.getResultMajor().equals("urn:nip:tack:result:major:success")) {
            throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.SEND_REQUEST_FAILED, "message from tack -> " + tack.getResultMinor());
        }
        boolean hasWarning = false;
        if (tack.getResultMinor() != null && !tack.getResultMinor().isEmpty()) {
            hasWarning = true;
            LOG.info("handlePostResponse : warning : " + tack.getResultMinor());
            LOG.info("handlePostResponse : resultMessage  : " + tack.getResultMessage());
        }
        return hasWarning;
    }

    @Override
    public final Map<Object, SignatureVerificationResult> handleGetResponse(GetResponse getResponse) throws GenAsyncBusinessConnectorException {
        HashMap<Object, SignatureVerificationResult> validationResult = new HashMap<Object, SignatureVerificationResult>();
        for (TAckResponse value : getResponse.getReturn().getTAckResponses()) {
            LOG.debug("handleGetResponse : tackResponse : xades : " + value.getXadesT() + ", tack : " + value.getTAck());
            validationResult.putAll(this.validateXadesT(value, value.getXadesT().getValue()));
        }
        for (MsgResponse msgResponse : getResponse.getReturn().getMsgResponses()) {
            if (msgResponse.getXadesT() == null) continue;
            validationResult.putAll(this.validateXadesT(msgResponse, msgResponse.getXadesT().getValue()));
        }
        if (!validationResult.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                this.logValidationResult(validationResult);
            }
            throw new GenAsyncSignatureValidationConnectorException(GenAsyncBusinessConnectorExceptionValues.SIGNATURE_VALIDATION_ERROR, validationResult);
        }
        return validationResult;
    }

    private void logValidationResult(Map<Object, SignatureVerificationResult> validationResults) {
        LOG.debug("validationResults : -------------------------");
        for (Object key : validationResults.keySet()) {
            SignatureVerificationResult signatureVerificationResult = validationResults.get(key);
            StringBuilder errorsSb = new StringBuilder();
            for (SignatureVerificationError error : signatureVerificationResult.getErrors()) {
                errorsSb.append(error).append(" ");
            }
            LOG.debug("key : " + key + "\t" + " validationResult errors : " + errorsSb.toString());
        }
        LOG.debug("--------------------------------------");
    }

    private Map<Object, SignatureVerificationResult> validateXadesT(Object value, byte[] xadesT) throws GenAsyncBusinessConnectorException {
        HashMap<Object, SignatureVerificationResult> vResult = new HashMap<Object, SignatureVerificationResult>();
        if (!ArrayUtils.isEmpty((byte[])xadesT)) {
            byte[] signedByteArray = ConnectorXmlUtils.toByteArray((Object)value);
            HashMap options = new HashMap();
            try {
                SignatureVerificationResult result = SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES_T).verify(signedByteArray, xadesT, options);
                if (!result.isValid()) {
                    vResult.put(value, result);
                }
            }
            catch (TechnicalConnectorException e) {
                throw new GenAsyncBusinessConnectorException(GenAsyncBusinessConnectorExceptionValues.SIGNATURE_VALIDATION_ERROR, e, e.getMessage());
            }
        }
        return vResult;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
    }
}

