/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.builders.impl;

import be.cin.mycarenet.esb.common.v2.CommonInput;
import be.cin.mycarenet.esb.common.v2.OrigineType;
import be.cin.nip.async.generic.Confirm;
import be.cin.nip.async.generic.Get;
import be.cin.nip.async.generic.MsgQuery;
import be.cin.nip.async.generic.MsgResponse;
import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.Query;
import be.cin.nip.async.generic.TAckResponse;
import be.cin.types.v1.Blob;
import be.ehealth.business.mycarenetdomaincommons.mapper.DomainBlobMapper;
import be.ehealth.businessconnector.genericasync.builders.RequestObjectBuilder;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public class RequestObjectBuilderImpl
implements RequestObjectBuilder {
    @Override
    public final Post buildPostRequest(CommonInput commonInput, Blob blob, byte[] xades) {
        Post post = new Post();
        post.setCommonInput(commonInput);
        post.setDetail(blob);
        if (xades != null) {
            post.setXadesT(DomainBlobMapper.mapB64fromByte((byte[])xades));
        }
        return post;
    }

    @Override
    public final Get buildGetRequest(OrigineType origin, MsgQuery msgQuery, Query tackQuery) {
        Get get = new Get();
        get.setMsgQuery(msgQuery);
        get.setOrigin(origin);
        get.setTAckQuery(tackQuery);
        return get;
    }

    @Override
    public final Confirm buildConfirmRequest(OrigineType origin, List<MsgResponse> msgResponses, List<TAckResponse> tackResponses) throws TechnicalConnectorException, DataFormatException {
        ArrayList<byte[]> msgHashValues = new ArrayList<byte[]>();
        ArrayList<byte[]> tackContents = new ArrayList<byte[]>();
        if (msgResponses == null || msgResponses.isEmpty()) {
            msgHashValues.add(new byte[0]);
        } else {
            for (MsgResponse msgResponse : msgResponses) {
                msgHashValues.add(msgResponse.getDetail().getHashValue());
            }
        }
        if (tackResponses == null || tackResponses.isEmpty()) {
            tackContents.add(new byte[0]);
        } else {
            for (TAckResponse tackResponse : tackResponses) {
                tackContents.add(tackResponse.getTAck().getValue());
            }
        }
        return this.buildConfirmRequestWithHashes(origin, msgHashValues, tackContents);
    }

    @Override
    public Confirm buildConfirmRequestWithHashes(OrigineType origin, List<byte[]> msgHashValues, List<byte[]> tackContents) {
        Confirm confirm = new Confirm();
        confirm.setOrigin(origin);
        confirm.getMsgHashValues().addAll(msgHashValues);
        confirm.getTAckContents().addAll(tackContents);
        return confirm;
    }

    @Override
    public Query createQuery(Integer max, Boolean include) {
        Query query = new Query();
        query.setInclude(include);
        query.setMax(max);
        return query;
    }

    @Override
    public MsgQuery createMsgQuery(Integer max, Boolean include, String ... messageNames) {
        MsgQuery msgQuery = new MsgQuery();
        msgQuery.setInclude(include);
        msgQuery.setMax(max);
        for (String messageName : messageNames) {
            msgQuery.getMessageNames().add(messageName);
        }
        return msgQuery;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
    }
}

