/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;


@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {"inbound"})
@XmlRootElement(name = "EchoResponse", namespace = "urn:be:fgov:ehealth:technicalconnector:tests:server")
public class EchoResponse {

    @XmlElement(name = "Inbound", namespace = "urn:be:fgov:ehealth:technicalconnector:tests:server", required = true)
    protected EchoResponse.Inbound inbound;

    public EchoResponse.Inbound getInbound() {
        return inbound;
    }

    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {"headers", "files"})
    public static class Inbound {

        @XmlElement(name = "Header", namespace = "urn:be:fgov:ehealth:technicalconnector:tests:server")
        protected List<EchoResponse.Inbound.Item> headers;

        @XmlElement(name = "File", namespace = "urn:be:fgov:ehealth:technicalconnector:tests:server")
        protected List<EchoResponse.Inbound.Item> files;

        public Map<String, String> getHeaders() {
            return convert(headers);
        }

        public Map<String, String> getFiles() {
            return convert(files);
        }

        private static Map<String, String> convert(List<EchoResponse.Inbound.Item> items) {
            Map<String, String> result = new HashMap<String, String>();
            if (items != null) {
                for (Item item : items) {
                    result.put(item.getId(), item.getValue());
                }
            }
            return result;
        }


        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {"value"})
        public static class Item {

            @XmlValue
            protected String value;

            @XmlAttribute(required = true)
            @XmlSchemaType(name = "anySimpleType")
            protected String id;

            public String getValue() {
                return value;
            }

            public String getId() {
                return id;
            }

        }

    }
}
