/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genericasync.mappers;

import be.cin.mycarenet.esb.common.v2.CareProviderType;
import be.cin.mycarenet.esb.common.v2.CommonInput;
import be.cin.mycarenet.esb.common.v2.IdType;
import be.cin.mycarenet.esb.common.v2.LicenseType;
import be.cin.mycarenet.esb.common.v2.NihiiType;
import be.cin.mycarenet.esb.common.v2.OrigineType;
import be.cin.mycarenet.esb.common.v2.PackageType;
import be.cin.mycarenet.esb.common.v2.ValueRefString;
import be.ehealth.business.mycarenetcommons.domain.CareProvider;
import be.ehealth.business.mycarenetcommons.domain.Identification;
import be.ehealth.business.mycarenetcommons.domain.McnPackageInfo;
import be.ehealth.business.mycarenetcommons.domain.Nihii;
import be.ehealth.business.mycarenetcommons.domain.Origin;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import java.util.ArrayList;
import org.dozer.DozerBeanMapper;

public final class CommonInputMapper {
    private CommonInputMapper() {
    }

    public static CommonInput mapCommonInputType(be.ehealth.business.mycarenetcommons.domain.CommonInput input) {
        ArrayList<String> myMappingFiles = new ArrayList<String>();
        myMappingFiles.add("dozer/genasync-commoninput.xml");
        DozerBeanMapper mapper = new DozerBeanMapper();
        mapper.setMappingFiles(myMappingFiles);
        CommonInput destObject = new CommonInput();
        mapper.map((Object)input, (Object)destObject);
        return destObject;
    }

    public static OrigineType mapOrigin(Origin origin) {
        String siteId;
        McnPackageInfo packageInfo;
        OrigineType result = new OrigineType();
        CareProvider careProvider = origin.getCareProvider();
        if (careProvider != null) {
            result.setCareProvider(CommonInputMapper.mapCareProvider(careProvider));
        }
        if ((packageInfo = origin.getMcnPackageInfo()) != null) {
            result.setPackage(CommonInputMapper.mapMcnPackage(packageInfo));
        }
        if ((siteId = origin.getSiteId()) != null) {
            result.setSiteID(CommonInputMapper.createValueRefString(siteId));
        }
        return result;
    }

    @Deprecated
    static PackageType mapPackage(PackageInfo packageInfo) {
        String userName;
        PackageType result = new PackageType();
        LicenseType license = new LicenseType();
        String password = packageInfo.getPassword();
        if (password != null) {
            license.setPassword(password);
        }
        if ((userName = packageInfo.getUserName()) != null) {
            license.setUsername(userName);
        }
        result.setLicense(license);
        String packageName = packageInfo.getPackageName();
        if (packageName != null) {
            result.setName(CommonInputMapper.createValueRefString(packageName));
        }
        return result;
    }

    static PackageType mapMcnPackage(McnPackageInfo packageInfo) {
        return CommonInputMapper.mapPackage((PackageInfo)packageInfo);
    }

    static CareProviderType mapCareProvider(CareProvider careProvider) {
        Identification physicalPerson;
        Identification organization;
        CareProviderType result = new CareProviderType();
        Nihii nihii = careProvider.getNihii();
        if (nihii != null) {
            result.setNihii(CommonInputMapper.mapNihii(nihii));
        }
        if ((organization = careProvider.getOrganization()) != null) {
            result.setOrganization(CommonInputMapper.mapIdType(organization));
        }
        if ((physicalPerson = careProvider.getPhysicalPerson()) != null) {
            result.setPhysicalPerson(CommonInputMapper.mapIdType(physicalPerson));
        }
        return result;
    }

    static IdType mapIdType(Identification organization) {
        String ssin;
        Nihii nihii;
        String name;
        IdType result = new IdType();
        String cbe = organization.getCbe();
        if (cbe != null) {
            result.setCbe(CommonInputMapper.createValueRefString(cbe));
        }
        if ((name = organization.getName()) != null) {
            result.setName(CommonInputMapper.createValueRefString(name));
        }
        if ((nihii = organization.getNihii()) != null) {
            result.setNihii(CommonInputMapper.mapNihii(nihii));
        }
        if ((ssin = organization.getSsin()) != null) {
            result.setSsin(CommonInputMapper.createValueRefString(ssin));
        }
        return result;
    }

    static NihiiType mapNihii(Nihii nihii) {
        String value;
        NihiiType result = new NihiiType();
        String quality = nihii.getQuality();
        if (quality != null) {
            result.setQuality(quality);
        }
        if ((value = nihii.getValue()) != null) {
            result.setValue(CommonInputMapper.createValueRefString(value));
        }
        return result;
    }

    static ValueRefString createValueRefString(String value) {
        ValueRefString result = new ValueRefString();
        result.setValue(value);
        return result;
    }
}

