/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;


/**
 * Test class for {@link DateUtils}
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class DateUtilsTest {

    /**
     * Tests different parsing
     * 
     * @author EHP
     */
    @Test
    public void testParsingDate() throws Exception {

        Assert.assertTrue(DateUtils.parseDate("2006-06-09").equals(new DateTime(2006, 6, 9, 0, 0, 0, 0)));

        DateUtils.parseDate("2006-06-09");
        DateUtils.parseDate("2006-W27-3");
        DateUtils.parseDate("2006-123");
        DateUtils.parseDate("2006-06-09T+02:00");
        DateUtils.parseDate("2006-W27-3T+02:00");
        DateUtils.parseDate("2006-123T+02:00");
        DateUtils.parseDateTime("2006-06-09T10:20:30.040");
        DateUtils.parseDateTime("2006-W27-3T10:20:30.040");
        DateUtils.parseDateTime("2006-123T10:20:30.040");
        DateUtils.parseDateTime("2006-06-09T10:20:30.040+02:00");
        DateUtils.parseDateTime("2006-W27-3T10:20:30.040+02:00");
        DateUtils.parseDateTime("2006-123T10:20:30.040+02:00");
        DateUtils.parseTime("T10:20:30.040");
        DateUtils.parseTime("T10.5");
        DateUtils.parseTime("T10:20:30.040+02:00");
        DateUtils.parseTime("T10.5+02:00");
        DateUtils.parseTime("10:20:30.040");
        DateUtils.parseTime("10.5");
        DateUtils.parseTime("10:20:30.040+02:00");
        DateUtils.parseTime("10.5+02:00");
    }

    @Test
    public void testPrintDate() throws Exception {
        DateTime parsedDateTime = DateUtils.parseDateTime("2006-06-09T10:20:30.040+02:00");
        String printedDate = DateUtils.printDate(parsedDateTime);
        String printedDateTime = DateUtils.printDateTime(parsedDateTime);
        String printedTime = DateUtils.printTime(parsedDateTime);
        Assert.assertEquals("2006-06-09", printedDate);
        Assert.assertEquals("2006-06-09T10:20:30.040+02:00", printedDateTime);
        Assert.assertEquals("10:20:30.040+02:00", printedTime);

    }

}
