/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.config.impl;

import java.util.List;

import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;
import be.fgov.ehealth.technicalconnector.tests.session.SessionDestroyer;
import be.fgov.ehealth.technicalconnector.tests.utils.AssertTools;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;


/**
 * Test to verify that the {@link be.ehealth.technicalconnector.config.ConfigurationModule} {@link ConfigurationModuleVersion}
 * 
 * @author EH053
 * 
 */
public class ConfigurationModuleVersionTest {

    private TestAppender appender = LoggingUtils.getTestAppender();

    @BeforeClass
    public static void init() throws Exception {
        LoggingUtils.bootstrap();
        SessionDestroyer.destroy();
    }

    @Test
    public void test() throws Exception {
        new ConfigurationModuleVersion().init(null);

        List<LoggingEvent> logEvents = appender.getLogEvents();
        if (logEvents.size() == 0) {
            Assert.fail("No log events");
        }
        LoggingEvent lastEntry = logEvents.get(logEvents.size() - 1);

        AssertTools.assertLoggingEvent(lastEntry, "debug", ConfigurationModuleVersion.class, "\\[CP Content\\] .*");

    }
}