/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.kgss;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.service.kgss.KgssService;
import be.ehealth.technicalconnector.service.kgss.domain.KeyResult;
import be.ehealth.technicalconnector.service.kgss.impl.KgssServiceImpl;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.etee.kgss._1_0.protocol.CredentialType;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetKeyRequestContent;
import be.fgov.ehealth.etee.kgss._1_0.protocol.GetNewKeyRequestContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KgssManager
implements SessionServiceWithCache {
    public static final String PROP_KGSS_IDENTIFIER_APPLICATIONID = "be.ehealth.technicalconnector.service.kgss.identifier.applicationid";
    private static final String PROP_KGSS_IDENTIFIER_ID = "be.ehealth.technicalconnector.service.kgss.identifier.value";
    private static final String PROP_KGSS_IDENTIFIER_SUBTYPE = "be.ehealth.technicalconnector.service.kgss.identifier.subtype";
    private static final String PROP_KGSS_IDENTIFIER_TYPE = "be.ehealth.technicalconnector.service.kgss.identifier.type";
    private static final String KGSS_TYPE = "CBE";
    private static final long KGSS_IDENTIFIER_VALUE = 809394427L;
    private static final String KGSS_APPLICATION_ID = "KGSS";
    private static final Logger LOG = LoggerFactory.getLogger(KgssManager.class);
    private Map<String, KeyResult> keyCache = new HashMap<String, KeyResult>();
    private static KgssManager instance = KgssManagerSingleton.INSTANCE.getKgssManager();
    private KgssService service;

    public static KgssManager getInstance() {
        return instance;
    }

    public static KgssManager getInstance(KgssService kgssService) {
        instance.setKgssService(kgssService);
        return instance;
    }

    private KgssManager(KgssService service) {
        this.service = service;
        Session.getInstance().registerSessionService(this);
    }

    public KeyResult get(String keyId, byte[] myEtk) throws TechnicalConnectorException {
        if (!this.keyCache.containsKey(keyId)) {
            LOG.debug("keyCache does not contain key, getting the key from KGSS Web Service: " + keyId);
            KeyResult key = this.getKeyFromKgss(keyId, myEtk);
            this.keyCache.put(keyId, key);
            LOG.debug("Added key to cache: " + keyId);
        }
        LOG.debug("returning key from cache: " + keyId);
        return this.keyCache.get(keyId);
    }

    public void add(List<CredentialType> allowedReaders, byte[] myEtk) throws TechnicalConnectorException {
        LOG.debug("Getting new key from KGSS Web Service");
        KeyResult key = this.getNewKeyFromKgss(allowedReaders, myEtk);
        this.keyCache.put(key.getKeyId(), key);
        LOG.debug("Added new key to cache: " + key.getKeyId());
    }

    public void add(String cacheId, List<CredentialType> allowedReaders, byte[] myEtk) throws TechnicalConnectorException {
        LOG.debug("Getting new key from KGSS Web Service: " + cacheId);
        KeyResult key = this.getNewKeyFromKgss(allowedReaders, myEtk);
        this.keyCache.put(cacheId, key);
        LOG.debug("Added new key to cache: " + cacheId);
    }

    public KeyResult remove(String key) {
        LOG.debug("removing key from cache: " + key);
        return this.keyCache.remove(key);
    }

    public boolean containsKey(String key) {
        return this.keyCache.containsKey(key);
    }

    protected KeyResult getKeyFromKgss(String keyId, byte[] myEtk) throws TechnicalConnectorException {
        LOG.debug("KeyIdentifier : " + keyId);
        GetKeyRequestContent req = new GetKeyRequestContent();
        req.setETK(myEtk);
        req.setKeyIdentifier(Base64.decode((byte[])keyId.getBytes()));
        SessionItem session = Session.getInstance().getSession();
        return this.service.getKey(req, KgssManager.getETKOfKGSS(), session);
    }

    public KeyResult getNewKeyFromKgss(List<CredentialType> allowedReaders, byte[] myEtk) throws TechnicalConnectorException {
        GetNewKeyRequestContent req = new GetNewKeyRequestContent();
        req.setETK(myEtk);
        req.getAllowedReaders().addAll(allowedReaders);
        return this.service.getNewKey(req, KgssManager.getETKOfKGSS());
    }

    private static byte[] getETKOfKGSS() throws TechnicalConnectorException {
        ConfigValidator config = ConfigFactory.getConfigValidator();
        String identifierType = config.getProperty(PROP_KGSS_IDENTIFIER_TYPE, KGSS_TYPE);
        String identifierSubType = config.getProperty(PROP_KGSS_IDENTIFIER_SUBTYPE);
        IdentifierType idType = IdentifierType.lookup(identifierType, identifierSubType, 48);
        Long id = config.getLongProperty(PROP_KGSS_IDENTIFIER_ID, 809394427L);
        String appId = config.getProperty(PROP_KGSS_IDENTIFIER_APPLICATIONID, KGSS_APPLICATION_ID);
        return KeyDepotManagerFactory.getKeyDepotManager().getEtk(idType, id, appId).getEncoded();
    }

    @Override
    public void flushCache() {
        this.keyCache.clear();
    }

    public void setKgssService(KgssService service) {
        this.service = service;
    }

    private static enum KgssManagerSingleton {
        INSTANCE;

        private KgssManager instance = new KgssManager(new KgssServiceImpl());

        public KgssManager getKgssManager() {
            return this.instance;
        }
    }
}

