/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.service.impl;

import be.ehealth.technicalconnector.beid.BeIDInfo;
import be.ehealth.technicalconnector.beid.domain.Identity;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.BeIDCredential;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import be.ehealth.technicalconnector.utils.ConfigurableImplementation;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.certra.protocol.v1.GenerateCertificateForRenewalRequest;
import be.fgov.ehealth.certra.protocol.v1.GenerateCertificateForRenewalResponse;
import be.fgov.ehealth.certra.protocol.v1.GenerateCertificateRequest;
import be.fgov.ehealth.certra.protocol.v1.GenerateCertificateResponse;
import be.fgov.ehealth.certra.protocol.v1.GetCertificateRequest;
import be.fgov.ehealth.certra.protocol.v1.GetCertificateResponse;
import be.fgov.ehealth.certra.protocol.v1.GetEHActorQualitiesRequest;
import be.fgov.ehealth.certra.protocol.v1.GetEHActorQualitiesResponse;
import be.fgov.ehealth.certra.protocol.v1.GetExistingApplicationIdsRequest;
import be.fgov.ehealth.certra.protocol.v1.GetExistingApplicationIdsResponse;
import be.fgov.ehealth.certra.protocol.v1.GetRevocableCertificatesRequest;
import be.fgov.ehealth.certra.protocol.v1.GetRevocableCertificatesResponse;
import be.fgov.ehealth.certra.protocol.v1.RevokeRequest;
import be.fgov.ehealth.certra.protocol.v1.RevokeResponse;
import be.fgov.ehealth.certra.protocol.v1.SearchCriteriumType;
import be.fgov.ehealth.etee.ra.aqdr._1_0.protocol.EHActorQualitiesDataRequest;
import be.fgov.ehealth.etee.ra.aqdr._1_0.protocol.EHActorQualitiesDataResponse;
import be.fgov.ehealth.etee.ra.aqdr._1_0.protocol.EntityType;
import be.fgov.ehealth.etee.ra.aqdr._1_0.protocol.Organization;
import be.fgov.ehealth.etee.ra.csr._1_0.protocol.ContactDataType;
import be.fgov.ehealth.etee.ra.csr._1_0.protocol.EHealthCertificateRequest;
import be.fgov.ehealth.etee.ra.csr._1_0.protocol.UsagesType;
import be.fgov.ehealth.etee.ra.revoke._1_0.protocol.RevocableCertificateType;
import be.fgov.ehealth.etee.ra.revoke._1_0.protocol.RevocableCertificatesDataRequest;
import be.fgov.ehealth.etee.ra.revoke._1_0.protocol.RevocableCertificatesDataResponse;
import be.fgov.ehealth.etee.ra.revoke._1_0.protocol.RevokeDataRequest;
import be.fgov.ehealth.technicalconnector.ra.domain.ContactData;
import be.fgov.ehealth.technicalconnector.ra.domain.NewCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.domain.RenewCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.domain.Result;
import be.fgov.ehealth.technicalconnector.ra.domain.RevokeCertificateContract;
import be.fgov.ehealth.technicalconnector.ra.enumaration.Status;
import be.fgov.ehealth.technicalconnector.ra.enumaration.UsageType;
import be.fgov.ehealth.technicalconnector.ra.exceptions.RaException;
import be.fgov.ehealth.technicalconnector.ra.service.AuthenticationCertificateRegistrationService;
import be.fgov.ehealth.technicalconnector.ra.utils.CertificateUtils;
import be.fgov.ehealth.technicalconnector.ra.utils.RaUtils;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationCertificateRegistrationServiceImpl
implements AuthenticationCertificateRegistrationService,
ConfigurableImplementation,
SessionServiceWithCache {
    private static final CertificateFactory CF;
    private static final Logger LOG;
    private Credential cred;
    private static Map<String, byte[]> cacheQualities;
    private static Map<String, byte[]> cacheRevokables;
    private static Map<String, List<X509Certificate>> cacheCertList;

    @Override
    public String request(NewCertificateContract contract) throws TechnicalConnectorException {
        GenerateCertificateForRenewalRequest payload;
        Validate.isTrue((boolean)contract.isContractViewed());
        EHealthCertificateRequest ehcsr = new EHealthCertificateRequest();
        ehcsr.setCsr(contract.getPkcs10DerEncoded());
        ehcsr.setContract(contract.getContract());
        ContactDataType contactDataType = AuthenticationCertificateRegistrationServiceImpl.map(contract.getContact());
        ehcsr.setContactData(contactDataType);
        if (null == ehcsr.getUsagesType()) {
            ehcsr.setUsagesType(new UsagesType());
        }
        for (UsageType etkUsageType : contract.getUsageTypes()) {
            ehcsr.getUsagesType().getUsageTypes().add(etkUsageType.getType());
        }
        String nationalNumber = contract.getRequestor().getNationalNumber();
        if (contract.getDistinguishedName().isNaturalPerson()) {
            ehcsr.setEHActorQualitiesSignedData(this.getQualities(nationalNumber, EntityType.NATURAL));
        } else {
            if (!cacheQualities.containsKey(nationalNumber)) {
                cacheQualities.put(nationalNumber, this.getQualities(nationalNumber, EntityType.LEGAL));
            }
            ehcsr.setEHActorQualitiesSignedData(cacheQualities.get(nationalNumber));
        }
        if (LOG.isDebugEnabled()) {
            ConnectorXmlUtils.dump((Object)ehcsr);
        }
        if (contract instanceof RenewCertificateContract) {
            payload = new GenerateCertificateForRenewalRequest();
            payload.setEhcsr(RaUtils.transform(this.cred, ehcsr, EHealthCertificateRequest.class));
            Result<GenerateCertificateForRenewalResponse> response = RaUtils.invokeCertRa(payload, "urn:be:fgov:ehealth:etee:certra:renewcertificate", GenerateCertificateForRenewalResponse.class);
            return response.getResult().getRequestId();
        }
        payload = new GenerateCertificateRequest();
        payload.setEhcsr(RaUtils.transform(this.cred, ehcsr, EHealthCertificateRequest.class));
        Result<GenerateCertificateResponse> response = RaUtils.invokeCertRa(payload, "urn:be:fgov:ehealth:etee:certra:generatecertificate", GenerateCertificateResponse.class);
        return response.getResult().getRequestId();
    }

    @Override
    public String renew(RenewCertificateContract contract) throws TechnicalConnectorException {
        return this.request(contract);
    }

    @Override
    public Result<Void> revoke(RevokeCertificateContract contract) throws TechnicalConnectorException {
        Validate.isTrue((boolean)contract.isContractViewed());
        String nationalNumber = BeIDInfo.getInstance().getIdentity().getNationalNumber();
        if (!cacheRevokables.containsKey(nationalNumber)) {
            cacheRevokables.put(nationalNumber, this.getRevocableCertificates(nationalNumber));
        }
        byte[] revocableCertificatesDataSignedResponse = cacheRevokables.get(nationalNumber);
        RevocableCertificatesDataResponse response = RaUtils.transform(revocableCertificatesDataSignedResponse, RevocableCertificatesDataResponse.class);
        ArrayList revocables = new ArrayList();
        revocables.addAll(response.getRevocablePersonalCertificates());
        revocables.addAll(response.getRevocableOrganizationCertificates());
        String requestId = null;
        for (RevocableCertificateType revocable : revocables) {
            X509Certificate cert = contract.getX509Certificate();
            if (!revocable.getAuthSerial().equals(cert.getSerialNumber().toString(10)) || !cert.getIssuerX500Principal().equals(new X500Principal(revocable.getIssuerDN()))) continue;
            requestId = revocable.getRequestId();
            break;
        }
        Validate.notNull(requestId);
        RevokeDataRequest revokeDataRequest = new RevokeDataRequest();
        revokeDataRequest.setRequestId(requestId);
        revokeDataRequest.setContract(contract.getContract());
        revokeDataRequest.setRevocableCertificatesDataSignedResponse(revocableCertificatesDataSignedResponse);
        RevokeRequest revokeReq = new RevokeRequest();
        revokeReq.setRevokeDataRequest(RaUtils.transform(this.cred, revokeDataRequest, RevokeDataRequest.class));
        Result<RevokeResponse> revokeResponse = RaUtils.invokeCertRa(revokeReq, "urn:be:fgov:ehealth:etee:certra:revokecertificate", RevokeResponse.class);
        if (revokeResponse.hasStatusError()) {
            return new Result<Void>("Unable to revoke certificate", revokeResponse.getCause());
        }
        return new Result<Void>((Void)null);
    }

    @Override
    public Result<X509Certificate[]> poll(String requestId) throws TechnicalConnectorException {
        Object[] cert = new X509Certificate[]{};
        GetCertificateRequest request = new GetCertificateRequest();
        request.setRequestId(requestId);
        Result<GetCertificateResponse> resp = RaUtils.invokeCertRa(request, "urn:be:fgov:ehealth:etee:certra:getcertificate", GetCertificateResponse.class);
        if (resp.getStatus().equals((Object)Status.OK)) {
            cert = (X509Certificate[])ArrayUtils.add((Object[])cert, (Object)CertificateUtils.toX509Certificate(resp.getResult().getCertificate()));
            for (byte[] cacert : resp.getResult().getCaCertificates()) {
                cert = (X509Certificate[])ArrayUtils.add((Object[])cert, (Object)CertificateUtils.toX509Certificate(cacert));
            }
            return new Result<Object[]>(cert);
        }
        if (resp.getStatus().equals((Object)Status.PENDING)) {
            return new Result<X509Certificate[]>(resp.getTime());
        }
        return new Result<X509Certificate[]>("Unable to obtain certificate", resp.getCause());
    }

    @Override
    public Result<List<X509Certificate>> getRevokableCertificates(Identity identity) throws TechnicalConnectorException {
        String nationalNumber = identity.getNationalNumber();
        if (!cacheRevokables.containsKey(nationalNumber)) {
            cacheRevokables.put(nationalNumber, this.getRevocableCertificates(nationalNumber));
        }
        byte[] revocableCertificatesDataSignedResponse = cacheRevokables.get(nationalNumber);
        if (!cacheCertList.containsKey(nationalNumber)) {
            cacheCertList.put(nationalNumber, this.convert(revocableCertificatesDataSignedResponse));
        }
        return new Result<List<X509Certificate>>(cacheCertList.get(nationalNumber));
    }

    private List<X509Certificate> convert(byte[] revocableCertificatesDataSignedResponse) throws RaException, TechnicalConnectorException {
        RevocableCertificatesDataResponse response = RaUtils.transform(revocableCertificatesDataSignedResponse, RevocableCertificatesDataResponse.class);
        ArrayList revocables = new ArrayList();
        revocables.addAll(response.getRevocablePersonalCertificates());
        revocables.addAll(response.getRevocableOrganizationCertificates());
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (RevocableCertificateType revocable : revocables) {
            try {
                X509Certificate[] certs = this.poll(revocable.getRequestId()).getResult();
                CertPath certChain = CF.generateCertPath(Arrays.asList(certs));
                result.add((X509Certificate)certChain.getCertificates().get(0));
            }
            catch (CertificateException e) {
                LOG.error("Unable to add revocable certificate", (Throwable)e);
            }
        }
        return result;
    }

    private byte[] getRevocableCertificates(String nationalNumber) throws TechnicalConnectorException {
        RevocableCertificatesDataRequest data = new RevocableCertificatesDataRequest();
        data.setSSIN(nationalNumber);
        GetRevocableCertificatesRequest request = new GetRevocableCertificatesRequest();
        request.setRevocableCertificatesDataRequest(RaUtils.transform(this.cred, data, RevocableCertificatesDataRequest.class));
        return RaUtils.invokeCertRa(request, "urn:be:fgov:ehealth:etee:certra:getrevocablecertificates", GetRevocableCertificatesResponse.class).getResult().getRevocableCertificatesDataResponse();
    }

    @Override
    public Result<List<be.fgov.ehealth.technicalconnector.ra.domain.Organization>> getOrganizationList(Identity identity) throws TechnicalConnectorException {
        String nationalNumber = identity.getNationalNumber();
        if (!cacheQualities.containsKey(nationalNumber)) {
            cacheQualities.put(nationalNumber, this.getQualities(nationalNumber, EntityType.LEGAL));
        }
        byte[] getQualityResponse = cacheQualities.get(nationalNumber);
        EHActorQualitiesDataResponse response = RaUtils.transform(getQualityResponse, EHActorQualitiesDataResponse.class);
        ArrayList<be.fgov.ehealth.technicalconnector.ra.domain.Organization> orgList = new ArrayList<be.fgov.ehealth.technicalconnector.ra.domain.Organization>();
        for (Organization org : response.getLegalPerson().getOrganizations()) {
            org.getIdentifier().getID();
            org.getIdentifier().getType();
            orgList.add(new be.fgov.ehealth.technicalconnector.ra.domain.Organization(org.getIdentifier().getID(), IdentifierType.lookup((String)org.getIdentifier().getType(), null, (int)48), org.getNameNl()));
        }
        return new Result<List<be.fgov.ehealth.technicalconnector.ra.domain.Organization>>(orgList);
    }

    @Override
    public Result<List<String>> getApplicationIdList(be.fgov.ehealth.technicalconnector.ra.domain.Organization organization) throws TechnicalConnectorException {
        GetExistingApplicationIdsRequest req = new GetExistingApplicationIdsRequest();
        SearchCriteriumType criteria = new SearchCriteriumType();
        criteria.setValue(organization.getId());
        criteria.setType(organization.getType().getType(48));
        req.setSearchCriterium(criteria);
        Result<GetExistingApplicationIdsResponse> response = RaUtils.invokeCertRa(req, "urn:be:fgov:ehealth:etee:certra:getexistingapplicationids", GetExistingApplicationIdsResponse.class);
        ArrayList<String> result = new ArrayList<String>();
        for (SearchCriteriumType crit : response.getResult().getSearchCriteria()) {
            result.add(crit.getApplicationID());
        }
        return new Result<List<String>>(result);
    }

    private byte[] getQualities(String nationalnumber, EntityType entity) throws TechnicalConnectorException {
        EHActorQualitiesDataRequest dataRequest = new EHActorQualitiesDataRequest();
        dataRequest.setSSIN(nationalnumber);
        dataRequest.setEntityType(entity);
        GetEHActorQualitiesRequest payload = new GetEHActorQualitiesRequest();
        payload.setEHActorQualitiesDataRequest(RaUtils.transform(this.cred, dataRequest, EHActorQualitiesDataRequest.class));
        Result<GetEHActorQualitiesResponse> response = RaUtils.invokeCertRa(payload, "urn:be:fgov:ehealth:etee:certra:getehactorqualities", GetEHActorQualitiesResponse.class);
        return response.getResult().getEHActorQualitiesDataResponse();
    }

    private static ContactDataType map(ContactData contactData) {
        ContactDataType contactDataType = new ContactDataType();
        contactDataType.setEmailPrivate(contactData.getEmailPrivate());
        contactDataType.setEmailGeneral(contactData.getEmailGeneral());
        contactDataType.setPhonePrivate(contactData.getPhonePrivate());
        contactDataType.setPhoneGeneral(contactData.getPhoneGeneral());
        return contactDataType;
    }

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        this.cred = BeIDCredential.getInstance((String)"CertRA", (String)"Signature");
    }

    public void flushCache() {
        cacheQualities.clear();
    }

    static {
        try {
            CF = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        LOG = LoggerFactory.getLogger(AuthenticationCertificateRegistrationServiceImpl.class);
        cacheQualities = new HashMap<String, byte[]>();
        cacheRevokables = new HashMap<String, byte[]>();
        cacheCertList = new HashMap<String, List<X509Certificate>>();
    }
}

