﻿using System;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.ws;
using be.ehealth.technicalconnector.ws.domain;
using be.fgov.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.utils.net;
using ikvm.extensions;
using java.util;
using NUnit.Framework;
using sun.invoke.util;

namespace be.ehealth.technicalconnector.config.impl
{
    [TestFixture]
    public class ConfigurationModuleSSLTest
    {
        private static Properties props;
        private static int port;
        private static HttpServerFake server;
        private readonly ConfigurationModuleSSL module = new ConfigurationModuleSSL();
        private static bool executed;

        [SetUp]
        public void init()
        {
            SessionInitializer.init(false);
            props = TestPropertiesNetLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties", ".net");
            port = HttpServerFake.FindFreePort();

            server = new HttpServerFake(false, port);
            server.start();
            verify();
        }

        [TearDown]
        public void teardown()
        {
            verify();
            server.stop();
  
        }

        private void verify()
        {
            try
            {
                call();
            }
            catch (Exception e)
            {
                if (e.GetType() == typeof(TechnicalConnectorException) && e.getMessage()
                    .contains("unable to find valid certification path to requested target"))
                {
                    return;
                }
            }
            Assert.Fail("Certificate should be not trusted!");
        }
        
        [Test]
        public void passthrough()
        {
            Configuration config = new ConfigurationFake();
            config.setProperty("connector.configurationmodule.ssl.verification.flavour", "passthrough");

            module.init(config);
            call();
            module.unload();
        }
        
        [Test]
        public void truststore()
        {
            Configuration config = new ConfigurationFake();
            config.setProperty("connector.configurationmodule.ssl.verifcation.flavour", "truststore");
            config.setProperty("connector.configurationmodule.ssl.trustore.location", "./P12/local/truststore.jks");
            config.setProperty("connector.configurationmodule.ssl.trustore.password", "system");


            module.init(config);
            call();
            module.unload();
        }

        private void call()
        {
            var genericRequest = new GenericRequest();

            genericRequest.setEndpoint("https://localhost:" + port + "/echo");
            genericRequest.setPayload("<dummy>boe</dummy>");

            var response = ServiceFactory.getGenericWsSender().send(genericRequest).asString();
            Console.WriteLine("Result [" + response + "]");

            Assert.IsTrue(response.Contains("&gt;boe&lt;"));
        }
    }
}