﻿/*
 * Copyright (c) eHealth
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.commons.core.v1;
using ikvm.extensions;
using java.util;
using NUnit.Framework;
using org.slf4j;
using util = java.util;
using java.io;
using org.apache.xml.security.utils;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehbox.v3.builders;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.ehbox.consultation.protocol.v3;
using be.fgov.ehealth.ehbox.core.v3;
using be.fgov.ehealth.ehbox.publication.protocol.v3;
using be.ehealth.businessconnector.ehbox.v3.session;
using be.ehealth.businessconnector.ehbox.v3.util;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.ehboxv3.session
{
	[TestFixture]
	public class Eh2EboxServicePublicationIntegrationTest
	{

	    /**
	     * Properties file
	     */
	    private static String FILE_AS_DOC = ".\\be.ehealth.businessconnector.ehboxv3.test.properties";

		private static Eh2eBoxServiceV3 service;

		[SetUp]
		public static void initIntegrationTest() {
			Properties props = TestPropertiesLoader.getProperties(FILE_AS_DOC,SupportedLanguages.NET.getAbbreviation());
			SessionInitializer.init(props, true, SupportedLanguages.NET.getAbbreviation());
			service = ServiceFactory.getEhealthBox2eBoxServiceV3();
		}

		[TearDown]
		public static void unloadSession() {
			Session.getInstance().unloadSession();
		}

		private static Logger LOG = LoggerFactory.getLogger(typeof(Eh2EboxServicePublicationIntegrationTest));

		/**
		 * @throws Exception
		 */
		[Test]
		public void testSendDocumentWithAnnex() {
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

			be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage documentMsg = 
				new be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			documentMsg.generatePublicationId();

			documentMsg.setBody(getDocument());
			documentMsg.getAnnexList().add(getAnnex());

			SendMessageRequest request = builder.buildMessage(documentMsg);
			request.getContentContext().getCustomMetas().add(getCustomMeta());
			
			verifyAnswer(service.sendMessage(request));
		}

		/**
		 * @throws Exception
		 */
		[Test]
		public void testSendDocument() {
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

			be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage documentMsg = 
				new be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			documentMsg.generatePublicationId();

			documentMsg.setBody(getDocument());

			SendMessageRequest request = builder.buildMessage(documentMsg);
			request.getContentContext().getCustomMetas().add(getCustomMeta());
			
			verifyAnswer(service.sendMessage(request));
		}

		/**
		 * Test the sendMessage operation from the eHealthBox Service with encoding who results in a type of message error (Encryption not
		 * allowed)
		 * 
		 * @throws Exception
		 */
		[Test]
		[ExpectedException( typeof( TechnicalConnectorException ) )]
		public void testSendEncryptedMessage() {
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

			be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage documentMsg = 
				new be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			documentMsg.setEncrypted(true);
			documentMsg.generatePublicationId();

			documentMsg.setBody(getDocument());

			SendMessageRequest request = builder.buildMessage(documentMsg);
			service.sendMessage(request);
		}

		/**
		 * Send a document with freetext who results in a type of message error (Freetext not allowed).
		 * 
		 * @throws Exception
		 */
		[Test]
		[ExpectedException( typeof( TechnicalConnectorException ) )]
		public void testSendDocumentWithFreeText() {
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

			be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage documentMsg = 
				new be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			documentMsg.generatePublicationId();

			documentMsg.setFreeText("Free text:" + UUID.randomUUID());

			documentMsg.setBody(getDocument());
			documentMsg.getAnnexList().add(getAnnex());

			SendMessageRequest request = builder.buildMessage(documentMsg);
			service.sendMessage(request);
		}

		/**
		 * @throws Exception
		 */
		[Test]
		[ExpectedException( typeof( TechnicalConnectorException ) )]
		public void testSendDocumentToWrongQuality() {
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

			be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage documentMsg = 
				new be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage();

			java.util.List addresseeList = new ArrayList();
			Addressee addressee = new Addressee(be.ehealth.technicalconnector.utils.IdentifierType.SSIN);
			addressee.setId(EhboxTestDataBuilder.getInssUser1());
			addressee.setQuality(QualityType.DOCTOR_SSIN);
			addresseeList.add(addressee);
			documentMsg.setDestinations(addresseeList);

			documentMsg.setImportant(false);
			documentMsg.generatePublicationId();

			documentMsg.setBody(getDocument());

			SendMessageRequest request = builder.buildMessage(documentMsg);
			service.sendMessage(request);
		}

		/**
		 * @throws Exception
		 */
		[Test]
		[ExpectedException( typeof( TechnicalConnectorException ) )]
		public void testSendDocumentToTooMuchDestinations() {
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();

			be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage documentMsg = 
				new be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage();

			java.util.List addresseeList = new ArrayList();
			Addressee addressee = new Addressee(be.ehealth.technicalconnector.utils.IdentifierType.SSIN);
			addressee.setId(EhboxTestDataBuilder.getInssUser1());
			addressee.setQuality(QualityType.DOCTOR_SSIN);
			
			addresseeList.add(addressee);
			addresseeList.add(addressee);
			addresseeList.add(addressee);
			addresseeList.add(addressee);
			addresseeList.add(addressee);
			addresseeList.add(addressee);
			documentMsg.setDestinations(addresseeList);

			documentMsg.setImportant(false);
			documentMsg.generatePublicationId();

			documentMsg.setBody(getDocument());

			SendMessageRequest request = builder.buildMessage(documentMsg);
			service.sendMessage(request);
		}


		/**
		 * Returns the destination
		 * 
		 * @return
		 */
		private java.util.List getDestination() {
			java.util.List addresseeList = new ArrayList();
			Addressee addressee = new Addressee(be.ehealth.technicalconnector.utils.IdentifierType.SSIN);
			addressee.setId(EhboxTestDataBuilder.getInssUser1());
			addressee.setQuality(QualityType.CITIZEN);
			addresseeList.add(addressee);

			return addresseeList;
		}

		/**
		 * Returns the document
		 * 
		 * @return
		 * @throws TechnicalConnectorException
		 */
		private Document getDocument() {
			Document doc = new Document();
			doc.setTitle("Document " + new Date());
			doc.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			doc.setMimeType("text/plain");
			doc.setFilename("be.ehealth.businessconnector.properties");
			return doc;
		}
		
		/**
		 * Returns the custom meta
		 * 
		 * @return
		 */
		private CustomMetaType getCustomMeta() {
			CustomMetaType meta = new CustomMetaType();
			meta.setKey("project");
			meta.setValue("multemediatt");
			return meta;
		}

		/**
		 * Returns the document
		 * 
		 * @return
		 * @throws TechnicalConnectorException
		 */
		private Document getAnnex() {
			Document annex = new Document();
			annex.setTitle("properties");
			annex.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			annex.setFilename("be.ehealth.technicalconnector.properties");
			annex.setMimeType("text/plain");
			return annex;
		}

		private void verifyAnswer(SendMessageResponse response) {
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getId());

			LOG.debug("Message Sent: " + response.getId());
			for (int i=0 ; i < response.getStatus().getMessages().size();i++) {
				LOG.debug("statusMessage" + ((LocalisedString)response.getStatus().getMessages().get(0)).getValue());
			}
			Assert.IsTrue(response.getStatus().getMessages().size() == 1);
			Assert.AreEqual(((LocalisedString)response.getStatus().getMessages().get(0)).getValue(), "SUCCESS");
		}
	}
}