package be.ehealth.technicalconnector.config.impl;

import static be.ehealth.technicalconnector.service.etee.CryptoFactory.OCSP_CONNECTION_TIMEOUT;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.service.etee.CryptoFactory;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;

/**
 * Created by EHP
 */
public class ConfigurationModuleOCSPTest {

    @Test
    public void initModuleShouldReloadOcspOptions() throws Exception {

        // Lazy init of OCSP options
        Assert.assertEquals(new Integer(3000), (Integer) CryptoFactory.getOCSPOptions()
                                                                      .get(OCSPOption.CONNECTION_TIMEOUT));

        ConfigurationModuleOCSP module = new ConfigurationModuleOCSP();
        Configuration configuration = ConfigFactory.getConfigValidator();
        configuration.setProperty(OCSP_CONNECTION_TIMEOUT, "6000");
        module.init(configuration);

        Assert.assertEquals(new Integer(6000), (Integer) CryptoFactory.getOCSPOptions()
                                                                      .get(OCSPOption.CONNECTION_TIMEOUT));

    }

}