using System;
using be.ehealth.technicalconnector.beid;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.config.impl;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.ws;
using be.ehealth.technicalconnector.ws.domain;
using be.fgov.ehealth.technicalconnector.beid;
using NUnit.Framework;
using org.ehcache.config;

namespace be.fgov.ehealth.technicalconnector
{
    [TestFixture]
    public class BeIdInfoGeneratorTest
    {
        [Test]
        public void BeIdInfo()
        {
            var beIdInfo = BeIDFactory.getBeIDInfo("test", false);
            Assert.AreEqual("Specimen", beIdInfo.getIdentity().getName());
        }

        [Test]
        public void SessionWithEid()
        {
            var config = ConfigFactory.getConfigValidator();
            config.setProperty("endpoint.sts","https://services-int.ehealth.fgov.be/IAM/Saml11TokenService/v1");
            BeIDFactory.setInstantiator(new BeIDNetInstantiator());
            Session.getInstance().createSessionEidOnly();
        }

        [Test]
        public void TestKeyExchange()
        {
            java.lang.System.setProperty("javax.net.debug", "all");
            var config = ConfigFactory.getConfigValidator();
            config.setProperty(ConfigurationModuleSSL.CONNECTOR_CONFIGURATIONMODULE_SSL_VERIFICATIONFLAVOUR,
                ConfigurationModuleSSL.SSL_VERIFICATION_FLAVOUR_PASSTHROUGH);
            config.reload();
            
            var req = new GenericRequest();
            req.setPayload("<boe />");
            req.setEndpoint("https://localhost");
            req.addDefaulHandlerChain();

            var response = ServiceFactory.getGenericWsSender().send(req).asString();
            Assert.AreEqual("<dch>rocks</dch>", response);
        }
    }
}