﻿/*
 * Copyright (c) eHealth
 */
using System;
using java.lang;
using NUnit.Framework;
using be.ehealth.businessconnector.therlink.builders;
using be.ehealth.businessconnector.therlink.domain;
using be.ehealth.businessconnector.therlink.domain.requests;
using be.ehealth.businessconnector.therlink.domain.responses;
using be.ehealth.businessconnector.therlink.exception;
using be.ehealth.businessconnector.therlink.mappers;
using be.ehealth.businessconnector.therlink.service;
using be.ehealth.businessconnector.therlink.util;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.service.sts.security;
using be.ehealth.technicalconnector.session;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;



namespace be.ehealth.businessconnector.therlink.service.impl
{
    /**
     * Integration tests superclass which will remove therapeutic links that needs to be cleared
     * 
     * @author EH065
     * 
     */
    public class AbstractTherlinkIsolationIntegrationTest
    {
        
        protected static TherLinkService therlinkWS = ServiceFactory.getTherLinkService();
        
        
        protected static CommonObjectBuilder commonBuilder;
        
        protected static RequestObjectBuilder requestObjectBuilder;
        
        protected static RequestObjectMapper requestObjectMapper;
        
        protected static ProofBuilder proofBuilder;
        
        protected static ResponseObjectMapper responseObjectMapper;
        
        
        [SetUp]
        public static void init () {
            SessionInitializer.init(TestConstants.THERLINK_TEST_PROPERTIES, SupportedLanguages.NET.getAbbreviation());
            
            commonBuilder = RequestObjectBuilderFactory.getCommonBuilder();
            proofBuilder = RequestObjectBuilderFactory.getProofBuilder();
            requestObjectBuilder = RequestObjectBuilderFactory.getRequestObjectBuilder();
            responseObjectMapper = MapperFactory.getResponseObjectMapper();
            requestObjectMapper = MapperFactory.getRequestObjectMapper();
        }
        
        [TearDown]
        public static void tearDown() {
            Session.getInstance().unloadSession();
        }
        
        /**
         * Revoke a therapeutic link using an Eid signing proof
         * 
         */
        protected void revokeLinkWithEidSigningProof(TherapeuticLink link){
            RevokeTherapeuticLinkRequest createRevokeTherapeuticLinkRequest = requestObjectBuilder.createRevokeTherapeuticLinkRequestWithProof(link, proofBuilder.createProofForEidReading());
            SAMLToken samlToken = Session.getInstance().getSession().getSAMLToken();
            
            be.fgov.ehealth.hubservices.core.v2.RevokeTherapeuticLinkResponse revokeTherapeuticLinkResponse = therlinkWS.revokeTherapeuticLink(samlToken, requestObjectMapper.mapRevokeTherapeuticLinkRequest(createRevokeTherapeuticLinkRequest));
            RevokeTherapeuticLinkResponse mappedRevokeResponse = responseObjectMapper.mapJaxbToRevokeTherapeuticLinkResponse(revokeTherapeuticLinkResponse);
            
            if (mappedRevokeResponse.getAcknowledge().isComplete()) {
                Console.WriteLine(">>> Therapeutic link revoked");
            } else {
                TherlinkTestUtils.extractAndAssertErrorMessage(mappedRevokeResponse.getAcknowledge(), null);
            }
        }
        
        /**
         * Revoke the link
         */
        protected void revokeLink(TherapeuticLink link) {
            SAMLToken samlToken = Session.getInstance().getSession().getSAMLToken();
            
            RevokeTherapeuticLinkRequest createRevokeTherapeuticLinkRequest = requestObjectBuilder.createRevokeTherapeuticLinkRequest(link);
            
            be.fgov.ehealth.hubservices.core.v2.RevokeTherapeuticLinkResponse revokeTherapeuticLinkResponse = therlinkWS.revokeTherapeuticLink(samlToken, requestObjectMapper.mapRevokeTherapeuticLinkRequest(createRevokeTherapeuticLinkRequest));
            RevokeTherapeuticLinkResponse revokeResponse = responseObjectMapper.mapJaxbToRevokeTherapeuticLinkResponse(revokeTherapeuticLinkResponse);
            
            if (revokeResponse.getAcknowledge().isComplete()) {
                Console.WriteLine(">>> Therapeutic link revoked");
            } else {
                TherlinkTestUtils.extractAndAssertErrorMessage(revokeResponse.getAcknowledge(), null);
            }
        }
        
    }
    
    
}
