﻿using be.ehealth.business.common.domain;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetcommons.domain;
using be.ehealth.businessconnector.mycarenet.agreementv2.builders;
using be.ehealth.businessconnector.mycarenet.agreementv2.domain;
using be.ehealth.businessconnector.test.testcommons.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.mycarenet.agreement.protocol.v2;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using javax.xml.soap;
using javax.xml.ws.soap;
using ikvm.extensions;
using org.joda.time;
using java.io;
using java.util;
using NUnit.Framework;
using System;

namespace be.ehealth.businessconnector.mycarenet.agreementv2.session
{
	
	public abstract class AbstractBaseIntegrationTest {
	
	    private static readonly string CHARSET = "utf-8";

	    protected void askAgreementTest(string inputReference,  string bundleLocation) {
            AgreementService service = AgreementSessionServiceFactory.getAgreementService();
            ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
            byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(CHARSET);

            ConnectorXmlUtils.dump(bundle);

            // input reference and AttributeQuery ID must match
            EncryptedRequestHolder requestBuilder = RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildAskAgreementRequest(
                    AgreementRequestInput.builder()
                            .isTest(true)
                            .inputReference(new InputReference(inputReference))
                            .fhirMessage(bundle)
                            .patientSsin(new Ssin("72070539942"))
                            .referenceDate(LocalDateTime.now())
                            .messageVersion("2.0")
                            .issuer("some issuer")
                            .commonInputAttributes(Arrays.asList(be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                            .key("urn:be:cin:nippin:purpose")
                                            .value("some purpose")
                                            .build(),
                                    be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                            .key("urn:be:cin:nippin:attemptNbr")
                                            .value(new java.lang.Integer(1))
                                            .build()))
                            .build());

            AskAgreementResponse response = service.askAgreement((AskAgreementRequest) requestBuilder.getRequest());

            assertResponse(responseBuilder.handleAskAgreementResponse(response, requestBuilder));
        }

        protected void consultAgreementTest(string inputReference,  string bundleLocation) {
            AgreementService service = AgreementSessionServiceFactory.getAgreementService();
            ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
            byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(CHARSET);

            ConnectorXmlUtils.dump(bundle);

            // input reference and AttributeQuery ID must match
            EncryptedRequestHolder requestBuilder = RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildConsultAgreementRequest(
                    AgreementRequestInput.builder()
                            .isTest(true)
                            .inputReference(new InputReference(inputReference))
                            .fhirMessage(bundle)
                            .patientSsin(new Ssin("86081523513"))
                            .referenceDate(LocalDateTime.now())
                            .messageVersion("2.0")
                            .issuer("some issuer")
                            .commonInputAttributes(Arrays.asList(be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                            .key("urn:be:cin:nippin:purpose")
                                            .value("some purpose")
                                            .build(),
                                    be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                            .key("urn:be:cin:nippin:attemptNbr")
                                            .value(new java.lang.Integer(1))
                                            .build()))
                            .build());

            ConsultAgreementResponse response = service.consultAgreement((ConsultAgreementRequest) requestBuilder.getRequest());

            SignedEncryptedResponseHolder encryptedResponseHolder = responseBuilder.handleConsultAgreementResponse(response, requestBuilder);
            Assert.IsNotNull(encryptedResponseHolder.getSignedData());
            Assert.IsNotNull(encryptedResponseHolder.getRawDecryptedBlob());
        }

        protected void checkSOAPFault(SOAPFaultException sfe) {
            java.util.List entries = new ArrayList();
            Iterator it = sfe.getFault().getDetail().getDetailEntries();
            while (it.hasNext()) entries.add((DetailEntry) it.next());

            Assert.IsTrue(entries.size() == 1);

            MarshallerHelper helper = new MarshallerHelper(typeof(BusinessError), typeof(BusinessError));
            BusinessError error = (BusinessError) helper.toObject((org.w3c.dom.Node) entries.get(0));

            Assert.AreEqual("EMPTY_BLOB", error.getCode());
            Assert.AreEqual("MYCARENET", error.getOrigin());

            java.util.List messages = error.getMessages();
            Assert.IsTrue(messages.size() == 1);

            LocalisedStringType message = (LocalisedStringType) messages.get(0);
            Assert.AreEqual("Blob is empty.", message.getValue());
        }

        private void assertResponse(SignedEncryptedResponseHolder response) {
            Assert.IsTrue(response.getSignatureVerificationResult().isValid(), "Errors found in the signature verification");
            Assert.IsNotNull(response.getXadesT());
            Assert.IsNotNull(response.getSignedData());
            Assert.IsNotNull(response.getRawDecryptedBlob());
            String expectedResponse = ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\eagreementv2\\responses\\mh-response-detail.xml");
            XmlAsserter.assertSimilar(expectedResponse, System.Text.Encoding.UTF8.GetString(response.getBusinessResponse()));
       }
	}
}
