/*
 * Copyright (c) eHealth
 */

package be.fgov.ehealth.technicalconnector.tests.junit.rule;

import be.ehealth.technicalconnector.beid.BeIDCardAdaptor;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.technicalconnector.tests.beid.DummyBeIDAdaptor;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import org.junit.rules.ExternalResource;

import static be.ehealth.technicalconnector.beid.impl.CommonsEidInstantiator.PROP_BEID_ADAPTOR;

/**
 * @author EHP
 */
public class BeIDInfoRule extends ExternalResource {

    private static String name;

    private BeIDInfoRule() {
        super();
    }

    public static SelectorStep activateEid() {
        return new InnerStep();
    }

    public BeIDInfoRule withLocation(String location) {
        ConfigFactory.getConfigValidator()
                .setProperty(DummyBeIDAdaptor.LOCATION, location);
        return this;
    }

    @Override
    protected void before() throws Throwable {
        LoggingUtils.bootstrap();
        ConfigFactory.getConfigValidator().setProperty(PROP_BEID_ADAPTOR, DummyBeIDAdaptor.class.getName());

    }

    @Override
    protected void after() {
        ConfigFactory.getConfigValidator().setProperty(PROP_BEID_ADAPTOR, BeIDCardAdaptor.class.getName());
    }

    public interface SelectorStep {

        NameSelectorStep withName();

        BeIDInfoRule basedOn(String location);

        BeIDInfoRule build();
    }


    public interface NameSelectorStep {

        BeIDInfoRule Alice();

        BeIDInfoRule Caroline();
    }

    private static class InnerStep implements NameSelectorStep, SelectorStep {

        @Override
        public NameSelectorStep withName() {
            return this;
        }

        @Override
        public BeIDInfoRule Alice() {
            return basedOn("/beid/Alice.xml");
        }

        @Override
        public BeIDInfoRule Caroline() {
            return basedOn("/beid/Caroline.xml");
        }

        @Override
        public BeIDInfoRule build() {
            return new BeIDInfoRule();
        }

        @Override
        public BeIDInfoRule basedOn(String location) {
            return build().withLocation(location);
        }

    }
}
