package be.fgov.ehealth.technicalconnector.bootstrap.bcp.verifier;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.ConfigurationFakeRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.LoggingRule;
import org.junit.*;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.ConfigurationFake;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;

public class StatusPageSignatureVerifierTest {

    @ClassRule
    public static LoggingRule logging = LoggingRule.with().consoleAppender().build();

    @Rule
    public ConfigurationFakeRule configurationFakeRule = new ConfigurationFakeRule();

    private void setUp(String keyStoreDir) {
        configurationFakeRule.setProperty("KEYSTORE_DIR", keyStoreDir);
        configurationFakeRule.setProperty("CAKEYSTORE_LOCATION", "caCertificateKeystore.jks");
        configurationFakeRule.setProperty("CAKEYSTORE_PASSWORD", "system");

    }

    @Test
    public void acceptance_v1() throws Exception {
        setUp("/P12/acc/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

    @Test
    public void production_v1() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

    @Test
    public void acceptance_v2() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }


    @Test
    public void production_v2() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

}