/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils;

import static be.fgov.ehealth.technicalconnector.tests.junit.matchers.DateTimeMatcher.isEqual;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;


/**
 * Test class for {@link DateUtils}
 *
 * @author EHP
 */
public class DateUtilsTest {


    @Test
    public void parseDate() throws Exception {

        assertNull(DateUtils.parseDate(null));
        assertThat(DateUtils.parseDate("2006-06-09"), isEqual(new DateTime(2006, 6, 9, 0, 0, 0, 0, DateTimeZone.forOffsetHours(2))));
        assertThat(DateUtils.parseDate("2006-06-09Z"), isEqual(new DateTime(2006, 6, 9, 0, 0, 0, 0, DateTimeZone.forOffsetHours(0))));
        assertThat(DateUtils.parseDate("2006-06-09+02:00"), isEqual(new DateTime(2006, 6, 9, 0, 0, 0, 0, DateTimeZone.forOffsetHours(2))));
        assertThat(DateUtils.parseDate("2006-06-09-02:00"), isEqual(new DateTime(2006, 6, 9, 0, 0, 0, 0, DateTimeZone.forOffsetHours(-2))));
    }

    @Test
    public void parseDateTime() throws Exception {
        assertNull(DateUtils.parseDateTime(null));
        assertThat(DateUtils.parseDateTime("2002-05-30T09:30:10.5"), isEqual(new DateTime(2002, 5, 30, 9, 30, 10, 500, DateTimeZone.forOffsetHours(2))));
        assertThat(DateUtils.parseDateTime("2002-05-30T09:30:10Z"), isEqual(new DateTime(2002, 5, 30, 9, 30, 10, 0, DateTimeZone.forOffsetHours(0))));
        assertThat(DateUtils.parseDateTime("2002-05-30T09:30:10-06:00"), isEqual(new DateTime(2002, 5, 30, 9, 30, 10, 0, DateTimeZone.forOffsetHours(-6))));
        assertThat(DateUtils.parseDateTime("2002-05-30T09:30:10+06:00"), isEqual(new DateTime(2002, 5, 30, 9, 30, 10, 0, DateTimeZone.forOffsetHours(6))));
    }

    @Test
    public void parseTime() throws Exception {
        assertNull(DateUtils.parseTime(null));
        assertThat(DateUtils.parseTime("09:30:10.5"), isEqual(new DateTime(1970, 1, 1, 9, 30, 10, 500, DateTimeZone.forOffsetHours(1))));
        assertThat(DateUtils.parseTime("09:30:10Z"), isEqual(new DateTime(1970, 1, 1, 9, 30, 10, 0, DateTimeZone.forOffsetHours(0))));
        assertThat(DateUtils.parseTime("10:20:30.040-02:00"), isEqual(new DateTime(1970, 1, 1, 10, 20, 30, 40, DateTimeZone.forOffsetHours(-2))));
        assertThat(DateUtils.parseTime("10:20:30.040+02:00"), isEqual(new DateTime(1970, 1, 1, 10, 20, 30, 40, DateTimeZone.forOffsetHours(2))));
    }

    @Test
    public void printTime() throws Exception {
        assertThat(DateUtils.printTime(DateUtils.parseTime(null)), nullValue());
        assertThat(DateUtils.printTime(DateUtils.parseTime("09:30:10.5")), is("09:30:10.500+01:00"));
        assertThat(DateUtils.printTime(DateUtils.parseTime("09:30:10Z")), is("09:30:10Z"));
        assertThat(DateUtils.printTime(DateUtils.parseTime("10:20:30.040-02:00")), is("10:20:30.040-02:00"));
        assertThat(DateUtils.printTime(DateUtils.parseTime("10:20:30.040+02:00")), is("10:20:30.040+02:00"));
    }

    @Test
    public void printDateTime() throws Exception {
        assertThat(DateUtils.printDateTime(DateUtils.parseDateTime(null)), nullValue());
        assertThat(DateUtils.printDateTime(DateUtils.parseDateTime("2002-05-30T09:30:10.5")), is("2002-05-30T09:30:10.500+02:00"));
        assertThat(DateUtils.printDateTime(DateUtils.parseDateTime("2002-05-30T09:30:10Z")), is("2002-05-30T09:30:10Z"));
        assertThat(DateUtils.printDateTime(DateUtils.parseDateTime("2002-05-30T10:20:30.040-02:00")), is("2002-05-30T10:20:30.040-02:00"));
        assertThat(DateUtils.printDateTime(DateUtils.parseDateTime("2002-05-30T10:20:30.040+02:00")), is("2002-05-30T10:20:30.040+02:00"));
    }

    @Test
    public void printDate() throws Exception {
        assertThat(DateUtils.printDate(DateUtils.parseDate(null)), nullValue());
        assertThat(DateUtils.printDate(DateUtils.parseDate("2002-05-30")), is("2002-05-30+02:00"));
        assertThat(DateUtils.printDate(DateUtils.parseDate("2002-05-30Z")), is("2002-05-30Z"));
        assertThat(DateUtils.printDate(DateUtils.parseDate("2002-05-30-02:00")), is("2002-05-30-02:00"));
        assertThat(DateUtils.printDate(DateUtils.parseDate("2002-05-30+02:00")), is("2002-05-30+02:00"));
    }

}
