/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.utils.SOAPFaultFactory;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SchemaValidatorHandler
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaValidatorHandler.class);
    private String[] schemaFiles;
    private int verify;
    public static final int VERIFY_INBOUND = 1;
    public static final int VERIFY_OUTBOUND = 2;
    public static final int VERIFY_BOTH = 3;

    public SchemaValidatorHandler(int verifyType, String ... schemaFile) {
        SchemaValidatorHandler.validVerifyType(verifyType);
        Validate.notEmpty((Object[])schemaFile);
        Validate.noNullElements((Object[])schemaFile);
        this.verify = verifyType;
        this.schemaFiles = schemaFile;
    }

    @Override
    public boolean handleInbound(SOAPMessageContext context) {
        if (this.verify == 3 || this.verify == 1) {
            LOG.info("Validating incoming message.");
            this.validate(context, "IN");
        }
        return true;
    }

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        if (this.verify == 3 || this.verify == 2) {
            LOG.info("Validating outgoing message.");
            this.validate(context, "OUT");
        }
        return true;
    }

    private void validate(SOAPMessageContext context, String mode) {
        try {
            SOAPBody body = context.getMessage().getSOAPBody();
            SOAPFault fault = body.getFault();
            if (fault != null) {
                return;
            }
            Node payloadNode = body.getFirstChild();
            ValidatorHelper.validate((Source)new DOMSource(payloadNode), this.isXOPEnabled(context), this.schemaFiles);
        }
        catch (Exception e) {
            SchemaValidatorHandler.dumpMessage(context.getMessage(), mode, LOG);
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw SOAPFaultFactory.newSOAPFaultException(e.getMessage(), e);
        }
        LOG.info("Message validation done.");
    }

    private boolean isXOPEnabled(SOAPMessageContext context) {
        boolean xopEnabled = false;
        if (context.containsKey((Object)"http://www.w3.org/2004/08/soap/features/http-optimization")) {
            xopEnabled = (Boolean)context.get((Object)"http://www.w3.org/2004/08/soap/features/http-optimization");
        }
        return xopEnabled;
    }

    private static void validVerifyType(int verifyType) {
        if (verifyType < 0 || verifyType > 3) {
            throw new IllegalArgumentException("Verify of type " + verifyType + " is not supported.");
        }
    }
}

