/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMimeHeaderManipulator
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMimeHeaderManipulator.class);

    protected void addToHeader(SOAPMessageContext context, String headerName, String ... headerValues) {
        MimeHeaders mimeHeaders;
        if (context.getMessage() != null && (mimeHeaders = context.getMessage().getMimeHeaders()) != null) {
            Object[] oldHeaderValues = mimeHeaders.getHeader(headerName);
            if (ArrayUtils.isNotEmpty((Object[])oldHeaderValues)) {
                LOG.info("Removing MIME header [{}] with value [{}]", (Object)headerName, (Object)StringUtils.join((Object[])oldHeaderValues, (String)","));
                mimeHeaders.removeHeader(headerName);
            }
            LOG.debug("Adding MIME header [{}] with value [{}]", (Object)headerName, (Object)StringUtils.join((Object[])headerValues, (String)","));
            for (String headerValue : headerValues) {
                mimeHeaders.addHeader(headerName, headerValue);
            }
        }
    }
}

