/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.common.util;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BusinessConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BusinessConfigUtil.class);
    public static final String USE_DEFAULT_PROPERTIES = ".usedefaultproperties";
    public static final String DEFAULT = "default";

    private BusinessConfigUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean retrieveBooleanProjectProperty(String prefix, String projectName, String suffix, boolean defaultValue) {
        ConfigValidator props = ConfigFactory.getConfigValidator();
        boolean result = props.getBooleanProperty(prefix + projectName + USE_DEFAULT_PROPERTIES, Boolean.valueOf(true)) != false ? props.getBooleanProperty(prefix + DEFAULT + suffix, Boolean.valueOf(defaultValue)).booleanValue() : props.getBooleanProperty(prefix + projectName + suffix, Boolean.valueOf(defaultValue)).booleanValue();
        LOG.debug("retrieveBooleanProjectProperty for " + prefix + "." + projectName + "." + suffix + " : returning " + result);
        return result;
    }

    public static boolean isNet() throws TechnicalConnectorException {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            if (resEnum.hasMoreElements()) {
                URL url = resEnum.nextElement();
                String path = url.getPath().toLowerCase();
                return StringUtils.contains((String)path, (String)"ikvm");
            }
            return false;
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

