/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifier;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierAbstract;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierInner;
import be.fgov.ehealth.etee.crypto.decrypt.SignedDataVerifierOuter;
import be.fgov.ehealth.etee.crypto.decrypt.SignerInfoAttributesReceiver;
import be.fgov.ehealth.etee.crypto.decrypt.SigningTimeVerifier;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.policies.SigningPolicy;
import be.fgov.ehealth.etee.crypto.utils.Iterables;
import java.util.Collection;

class SignedDataVerifierFactory {
    private static SignedDataVerifierFactory instance;

    SignedDataVerifierFactory() {
    }

    public static synchronized SignedDataVerifierFactory getInstance() {
        if (instance == null) {
            instance = new SignedDataVerifierFactory();
        }
        return instance;
    }

    public SignedDataVerifier createInnerSignedDataVerifier(SigningPolicy signingPolicy, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesReceiver) {
        return this.createInnerSignedDataVerifier(Iterables.newList(signingPolicy), requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesReceiver);
    }

    public SignedDataVerifierAbstract createInnerSignedDataVerifier(Collection<SigningPolicy> signingPolicies, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesReceiver) {
        return new SignedDataVerifierInner(signingPolicies, requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesReceiver);
    }

    public SignedDataVerifier createOuterSignedDataVerifier(SigningPolicy signingPolicy, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesParser, SigningTimeVerifier signingTimeVerifier) {
        return this.createOuterSignedDataVerifier(Iterables.newList(signingPolicy), requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesParser, signingTimeVerifier);
    }

    public SignedDataVerifierAbstract createOuterSignedDataVerifier(Collection<SigningPolicy> signingPolicies, int[] requiredKeyUsage, OCSPChecker ocspChecker, CertPathChecker certPathChecker, SignerInfoAttributesReceiver signerInfoAttributesParser, SigningTimeVerifier signingTimeVerifier) {
        return new SignedDataVerifierOuter(signingPolicies, requiredKeyUsage, ocspChecker, certPathChecker, signerInfoAttributesParser, signingTimeVerifier);
    }
}

