#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.session
{
    using System;
    using System.Text;

    using be.ehealth.technicalconnector.config;
    using be.ehealth.technicalconnector.generic.session;

    using java.io;
    using java.net;

    using javax.xml.parsers;

    using NUnit.Framework;

    using org.w3c.dom;

    /**
     * Generic Sender Integration Test This test shows how to use the generic sender.
     *
     */
    [TestFixture]
    public class GenericSenderIntegrationTest : AbstractServiceIntegrationTest
    {
        #region Fields

        private static String ENDPOINT = "https://services-acpt.ehealth.fgov.be/ehBoxConsultation/v2";

        #endregion Fields

        #region Methods

        [Test]
        public void testGenericSenderDocument()
        {
            GenericService service = GenericSessionServiceFactory.getGenericService();
            String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v2'><Source>INBOX</Source></ns2:GetMessagesListRequest>";

            Node response = service.sendDocument(parse(payload), ENDPOINT);
            Assert.IsNotNull(response);
        }

        [Test]
        public void testGenericSenderDocumentWithUrl()
        {
            GenericService service = GenericSessionServiceFactory.getGenericService();
            String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v2'><Source>INBOX</Source></ns2:GetMessagesListRequest>";

            Node response = service.sendDocument(parse(payload), new URL(ENDPOINT));
            Assert.IsNotNull(response);
        }

        [Test]
        public void testGenericSenderXML()
        {
            GenericService service = GenericSessionServiceFactory.getGenericService();
            String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v2'><Source>INBOX</Source></ns2:GetMessagesListRequest>";

            String response = service.sendXML(payload, ENDPOINT);
            Assert.IsNotNull(response);
        }

        [Test]
        public void testGenericSenderXMLWithURL()
        {
            GenericService service = GenericSessionServiceFactory.getGenericService();
            String payload = "<ns2:GetMessagesListRequest xmlns:ns2='urn:be:fgov:ehealth:ehbox:consultation:protocol:v2'><Source>INBOX</Source></ns2:GetMessagesListRequest>";
            String response = service.sendXML(payload, new URL(ENDPOINT));
            Assert.IsNotNull(response);
        }

        private Document parse(String input)
        {
            InputStream sbis = new ByteArrayInputStream(new UTF8Encoding().GetBytes(input));
            DocumentBuilderFactory b = DocumentBuilderFactory.newInstance();
            b.setNamespaceAware(true);
            javax.xml.parsers.DocumentBuilder db = b.newDocumentBuilder();
            return db.parse(sbis);
        }

        #endregion Methods
    }
}