/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.commons.eid.jca;

import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.client.impl.BeIDDigest;
import be.fedict.commons.eid.client.spi.UserCancelledException;
import be.fedict.commons.eid.jca.BeIDKeyStore;
import be.fedict.commons.eid.jca.UserCancelledSignatureException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.smartcardio.CardException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeIDPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBeIDPrivateKey.class);
    private final FileType certificateFileType;
    protected BeIDCard beIDCard;
    private final boolean logoff;
    private final boolean allowFailingLogoff;
    private final boolean autoRecovery;
    private final BeIDKeyStore beIDKeyStore;
    private final String applicationName;
    protected X509Certificate authenticationCertificate;

    public AbstractBeIDPrivateKey(FileType certificateFileType, BeIDCard beIDCard, boolean logoff, boolean allowFailingLogoff, boolean autoRecovery, BeIDKeyStore beIDKeyStore, String applicationName) {
        LOGGER.debug("constructor: {}", (Object)certificateFileType);
        this.certificateFileType = certificateFileType;
        this.beIDCard = beIDCard;
        this.logoff = logoff;
        this.allowFailingLogoff = allowFailingLogoff;
        this.autoRecovery = autoRecovery;
        this.beIDKeyStore = beIDKeyStore;
        this.applicationName = applicationName;
    }

    @Override
    public String getAlgorithm() {
        if (this.beIDCard.isEC()) {
            return "EC";
        }
        return "RSA";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    byte[] sign(byte[] digestValue, BeIDDigest digestAlgo) throws SignatureException {
        byte[] signatureValue;
        block13: {
            LOGGER.debug("auto recovery: {}", (Object)this.autoRecovery);
            try {
                if (this.autoRecovery && null == this.authenticationCertificate) {
                    try {
                        this.authenticationCertificate = this.beIDCard.getAuthenticationCertificate();
                    }
                    catch (IOException | InterruptedException | CertificateException | CardException exception) {
                        // empty catch block
                    }
                }
                try {
                    signatureValue = this.beIDCard.sign(digestValue, digestAlgo, this.certificateFileType, false, this.applicationName);
                }
                catch (UserCancelledException | IOException | InterruptedException | CardException e) {
                    if (this.autoRecovery) {
                        X509Certificate newAuthenticationCertificate;
                        LOGGER.debug("trying to recover...");
                        this.beIDCard = this.beIDKeyStore.getBeIDCard(true);
                        if (null != this.authenticationCertificate && !this.authenticationCertificate.equals(newAuthenticationCertificate = this.beIDCard.getAuthenticationCertificate())) {
                            throw new SignatureException("different eID card");
                        }
                        signatureValue = this.beIDCard.sign(digestValue, digestAlgo, this.certificateFileType, false, this.applicationName);
                    }
                    throw e;
                }
                if (!this.logoff) break block13;
                try {
                    this.beIDCard.logoff();
                }
                catch (Exception e) {
                    if (this.allowFailingLogoff) {
                        LOGGER.error("eID logoff failed.");
                        break block13;
                    }
                    throw e;
                }
            }
            catch (Exception ex) {
                if (ex instanceof UserCancelledException) {
                    throw new UserCancelledSignatureException(ex);
                }
                throw new SignatureException(ex);
            }
        }
        return signatureValue;
    }
}

