package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;

public class ConfigurationFake extends AbstractConfigurationImpl {

    private RecursiveProperties properties;

    public ConfigurationFake() throws TechnicalConnectorException {
        properties = new RecursiveProperties(false);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    @Override
    public void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        return properties.containsKey(key);
    }

    @Override
    public Configuration getCurrentConfig() throws TechnicalConnectorException {
        return this;
    }

    @Override
    public void invalidate() throws TechnicalConnectorException {
        properties = new RecursiveProperties(false);
    }

    @Override
    public void reload() throws TechnicalConnectorException {
//
    }

    @Override
    public boolean isReloading() {
        return false;
    }
}
