﻿using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.handler;
using be.ehealth.technicalconnector.ws.domain;
using java.util;
using org.w3c.dom;
using java.security;
using org.bouncycastle;
using org.bouncycastle.jce.provider;

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

namespace be.ehealth.technicalconnector.ws
{
	using System;
	using System.IO;
	using System.Text;

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.sts.security;
	using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.tests.utils.net;
	using be.ehealth.technicalconnector.ws;

	using NUnit.Framework;

	/**
	 * The Class GenericWsUnsecuredITTest.
	 */
	[TestFixture]
	class GenericWSUnsecuredITTest
	{
		#region Fields

		private static Properties props;
		
		#endregion Fields
		
		#region Methods

		[SetUp]
		public static void init()
		{
			
		  // props = TestPropertiesNetLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties",".net");
		   ConfigFactory.getConfigValidator().getConfig().setProperty("KEYSTORE_DIR", ".\\P12\\acc\\");
		}

		/**
		 * Invoke the check Connection method on the Platform Integration Test
		 * 
		 * This test includes the following main steps:
		 * <li>1. Set the URL to the web service end-point
		 * <li>2. Get the payload
		 * <li>3. Send the message
		 */
		[Test]
		public void testSendUnsecured() {
			Assert.IsNotNull(invoke().asString());
		}

		/**
		 * Invoke the check Connection method on the Platform Integration Test
		 * 
		 * This test includes the following main steps:
		 * <li>1. Set the URL to the web service end-point
		 * <li>2. Get the payload
		 * <li>3. Send the message
		 */
		[Test]
		public void testSendUnsecuredDOM() {
			Assert.IsNotNull(invoke().asNode());
		}

		private GenericResponse invoke()
		{
			java.lang.System.setProperty("https.protocols", "TLSv1.1,TLSv1.2");
			java.lang.System.setProperty("javax.net.debug", "all");
			Security.insertProviderAt(new BouncyCastleProvider(),0);
			
			GenericRequest request = new GenericRequest();
			request.setPayload(getPayload());
			request.setEndpoint("https://servicestest.cozo.be/IntrahubServiceTest/service.asmx");
			request.addDefaulHandlerChain();

			return be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender().send(request);
		}

		/**
		 * Builds the payload (string) for the request.
		 */
		private String getPayload() {
			StringBuilder sb = new StringBuilder();
			sb.Append("<CheckConnectionRequest xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:v1\">");
			sb.Append("<Message xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">Hello this is your captain speeking</Message>");
			sb.Append("<Timestamp xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">");
			sb.Append(DateUtils.printDateTime(new org.joda.time.DateTime()));
			sb.Append("</Timestamp>");
			sb.Append("</CheckConnectionRequest>");
			return sb.ToString();

		}

		#endregion Methods
	}
}