/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.crypto.dsig.Reference;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.action.AbstractDerivedAction;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureDerivedAction
extends AbstractDerivedAction
implements Action {
    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, Document doc, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = reqData.getCallbackHandler();
        if (callbackHandler == null) {
            callbackHandler = handler.getPasswordCallbackHandler(reqData);
        }
        SignatureActionToken signatureToken = null;
        if (actionToken instanceof SignatureActionToken) {
            signatureToken = (SignatureActionToken)actionToken;
        }
        if (signatureToken == null) {
            signatureToken = reqData.getSignatureToken();
        }
        WSPasswordCallback passwordCallback = handler.getPasswordCB(signatureToken.getUser(), 32768, callbackHandler, reqData);
        WSSecDKSign wsSign = new WSSecDKSign(reqData.getWssConfig());
        if (signatureToken.getSignatureAlgorithm() != null) {
            wsSign.setSignatureAlgorithm(signatureToken.getSignatureAlgorithm());
        }
        if (signatureToken.getDigestAlgorithm() != null) {
            wsSign.setDigestAlgorithm(signatureToken.getDigestAlgorithm());
        }
        if (signatureToken.getC14nAlgorithm() != null) {
            wsSign.setSigCanonicalization(signatureToken.getC14nAlgorithm());
        }
        wsSign.setUserInfo(signatureToken.getUser(), passwordCallback.getPassword());
        if (reqData.isUse200512Namespace()) {
            wsSign.setWscVersion(2);
        } else {
            wsSign.setWscVersion(1);
        }
        if (signatureToken.getDerivedKeyLength() > 0) {
            wsSign.setDerivedKeyLength(signatureToken.getDerivedKeyLength());
        }
        Element tokenElement = this.setupTokenReference(reqData, signatureToken, wsSign, passwordCallback, doc);
        wsSign.setAttachmentCallbackHandler(reqData.getAttachmentCallbackHandler());
        wsSign.setStoreBytesInAttachment(reqData.isStoreBytesInAttachment());
        try {
            ArrayList<WSEncryptionPart> parts = signatureToken.getParts();
            if (parts == null || parts.isEmpty()) {
                WSEncryptionPart encP = new WSEncryptionPart(reqData.getSoapConstants().getBodyQName().getLocalPart(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
                parts = new ArrayList<WSEncryptionPart>();
                parts.add(encP);
            }
            wsSign.setParts((List<WSEncryptionPart>)parts);
            wsSign.prepare(doc, reqData.getSecHeader());
            List<Reference> referenceList = wsSign.addReferencesToSign((List<WSEncryptionPart>)parts, reqData.getSecHeader());
            Node nextSibling = null;
            if (tokenElement == null && "EncryptedKey".equals(signatureToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findEncryptedKeySibling(reqData);
            } else if (tokenElement == null && "SecurityContextToken".equals(signatureToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findSCTSibling(reqData);
            }
            if (nextSibling == null) {
                wsSign.computeSignature(referenceList);
            } else {
                wsSign.computeSignature(referenceList, true, (Element)nextSibling);
            }
            if (nextSibling == null) {
                wsSign.prependDKElementToHeader(reqData.getSecHeader());
            } else {
                reqData.getSecHeader().getSecurityHeader().insertBefore(wsSign.getdktElement(), wsSign.getSignatureElement());
            }
            if (tokenElement != null) {
                WSSecurityUtil.prependChildElement(reqData.getSecHeader().getSecurityHeader(), tokenElement);
            }
            reqData.getSignatureValues().add(wsSign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "empty", new Object[]{"Error during Signature: "});
        }
    }

    private Element setupTokenReference(RequestData reqData, SignatureActionToken signatureToken, WSSecDKSign wsSign, WSPasswordCallback passwordCallback, Document doc) throws WSSecurityException {
        String derivedKeyTokenReference = signatureToken.getDerivedKeyTokenReference();
        if ("EncryptedKey".equals(derivedKeyTokenReference)) {
            wsSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            if (reqData.getEncryptionToken() != null && reqData.getEncryptionToken().getKey() != null && reqData.getEncryptionToken().getKeyIdentifier() != null) {
                byte[] ek = reqData.getEncryptionToken().getKey();
                String tokenIdentifier = reqData.getEncryptionToken().getKeyIdentifier();
                wsSign.setExternalKey(ek, tokenIdentifier);
                return null;
            }
            WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
            encrKeyBuilder.setUserInfo(signatureToken.getUser());
            if (signatureToken.getDerivedKeyIdentifier() != 0) {
                encrKeyBuilder.setKeyIdentifierType(signatureToken.getDerivedKeyIdentifier());
            } else {
                encrKeyBuilder.setKeyIdentifierType(8);
            }
            encrKeyBuilder.prepare(doc, signatureToken.getCrypto());
            byte[] ek = encrKeyBuilder.getEphemeralKey();
            String tokenIdentifier = encrKeyBuilder.getId();
            signatureToken.setKey(ek);
            signatureToken.setKeyIdentifier(tokenIdentifier);
            wsSign.setExternalKey(ek, tokenIdentifier);
            return encrKeyBuilder.getEncryptedKeyElement();
        }
        if ("SecurityContextToken".equals(derivedKeyTokenReference)) {
            if (reqData.isUse200512Namespace()) {
                wsSign.setCustomValueType("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct");
            } else {
                wsSign.setCustomValueType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            }
            if (reqData.getEncryptionToken() != null && reqData.getEncryptionToken().getKey() != null && reqData.getEncryptionToken().getKeyIdentifier() != null) {
                byte[] secret = reqData.getEncryptionToken().getKey();
                String tokenIdentifier = reqData.getEncryptionToken().getKeyIdentifier();
                wsSign.setExternalKey(secret, tokenIdentifier);
                return null;
            }
            String tokenIdentifier = IDGenerator.generateID((String)"uuid:");
            wsSign.setExternalKey(passwordCallback.getKey(), tokenIdentifier);
            signatureToken.setKey(passwordCallback.getKey());
            signatureToken.setKeyIdentifier(tokenIdentifier);
            int version = 2;
            if (!reqData.isUse200512Namespace()) {
                version = 1;
            }
            SecurityContextToken sct = new SecurityContextToken(version, doc, tokenIdentifier);
            return sct.getElement();
        }
        if (signatureToken.getDerivedKeyIdentifier() != 0) {
            wsSign.setKeyIdentifierType(signatureToken.getDerivedKeyIdentifier());
        } else {
            wsSign.setKeyIdentifierType(8);
        }
        byte[] key = null;
        if (passwordCallback.getKey() != null) {
            key = passwordCallback.getKey();
        } else if (signatureToken.getKey() != null) {
            key = signatureToken.getKey();
        } else {
            Crypto crypto = signatureToken.getCrypto();
            key = crypto.getPrivateKey(signatureToken.getUser(), passwordCallback.getPassword()).getEncoded();
        }
        wsSign.setCrypto(signatureToken.getCrypto());
        wsSign.setExternalKey(key, (String)null);
        return null;
    }
}

