/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModuleServiceLoader
implements ConfigurationModule {
    public static final String SERVICELOADER_ROOTKEY = "configurationmodule.serviceloader";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleServiceLoader.class);

    @Override
    public void init(Configuration config) throws TechnicalConnectorException {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        if (!LOG.isDebugEnabled()) {
            return;
        }
        List<String> serviceLoaders = config.getMatchingProperties(SERVICELOADER_ROOTKEY);
        for (String serviceLoader : serviceLoaders) {
            String[] splittedServiceLoader = serviceLoader.split(":", 2);
            try {
                Method method;
                Class<?> provider = Class.forName(splittedServiceLoader[0]);
                Object result = null;
                if (splittedServiceLoader.length == 1) {
                    method = provider.getMethod("newInstance", new Class[0]);
                    result = method.invoke(provider, new Object[0]);
                } else if (splittedServiceLoader.length == 2) {
                    method = provider.getMethod("newInstance", String.class);
                    result = method.invoke(provider, splittedServiceLoader[1]);
                } else {
                    LOG.debug("Unsupported serviceLoader value [{}].", (Object)serviceLoader);
                    break;
                }
                CodeSource source = result.getClass().getProtectionDomain().getCodeSource();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(MessageFormat.format("{0} implementation: {1} loaded from: {2}", splittedServiceLoader[0], result.getClass().getName(), source == null ? "Java Runtime" : source.getLocation()));
            }
            catch (Exception e) {
                LOG.debug("{}: {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            }
        }
    }

    @Override
    public void unload() throws TechnicalConnectorException {
        LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
    }
}

