/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.domain;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenericResponse {
    private static final Logger LOG = LoggerFactory.getLogger(GenericResponse.class);
    private SOAPMessage message;

    public GenericResponse(SOAPMessage message) {
        this.message = message;
    }

    public Node asNode() throws SOAPException {
        return this.getFirstChildElement();
    }

    public String asString() throws TechnicalConnectorException, SOAPException {
        Element response = this.getFirstChildElement();
        if (response != null) {
            return ConnectorXmlUtils.toString(response);
        }
        LOG.warn("An empty body is recieved, returning empty String");
        return "";
    }

    public SOAPMessage getSOAPMessage() {
        return this.message;
    }

    public <T> T asObject(Class<T> clazz) throws SOAPException {
        if (!clazz.isAnnotationPresent(XmlRootElement.class)) {
            throw new IllegalArgumentException("Class [" + clazz + "] is not annotated with @XMLRootElement");
        }
        this.getSOAPException();
        MarshallerHelper<T, T> helper = new MarshallerHelper<T, T>(clazz, clazz);
        helper.clearAttachmentPartMap();
        Iterator attachmentPartIterator = this.message.getAttachments();
        while (attachmentPartIterator.hasNext()) {
            AttachmentPart element = (AttachmentPart)attachmentPartIterator.next();
            helper.addAttachmentPart(this.getAttachmentPartId(element), element);
        }
        return helper.toObject(this.getFirstChildElement());
    }

    private String getAttachmentPartId(AttachmentPart element) {
        return this.sanitizePartId(StringUtils.substringBetween((String)element.getContentId(), (String)"<", (String)">"));
    }

    private String sanitizePartId(String cid) {
        return cid.replaceAll("cid:", "");
    }

    public byte[] getAttachment(String cid) throws SOAPException {
        Iterator attachmentPartIterator = this.message.getAttachments();
        while (attachmentPartIterator.hasNext()) {
            AttachmentPart element = (AttachmentPart)attachmentPartIterator.next();
            if (!StringUtils.equals((String)this.sanitizePartId(cid), (String)this.getAttachmentPartId(element))) continue;
            return element.getRawContentBytes();
        }
        throw new SOAPException("Unable to find attachment with id [" + cid + "]");
    }

    public Source asSource() throws SOAPException {
        return new DOMSource(this.getFirstChildElement());
    }

    private Element getFirstChildElement() throws SOAPException {
        this.getSOAPException();
        SOAPBody n = this.message.getSOAPPart().getEnvelope().getBody();
        return ConnectorXmlUtils.getFirstChildElement((Node)n);
    }

    public void getSOAPException() throws SOAPException {
        if (this.message == null || this.message.getSOAPBody() == null) {
            throw new SOAPException("No message SOAPmessage recieved");
        }
        SOAPFault fault = this.message.getSOAPBody().getFault();
        if (fault != null) {
            try {
                if (LOG.isErrorEnabled()) {
                    LOG.error("SOAPFault: {}", (Object)ConnectorXmlUtils.flatten(ConnectorXmlUtils.toString((Node)fault)));
                }
            }
            catch (TechnicalConnectorException e) {
                LOG.debug("Unable to dump SOAPFault. Reason [{}]", (Object)e.getMessage(), (Object)e);
            }
            throw new SOAPFaultException(fault);
        }
    }
}

