/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;

public class Expectation
extends ObjectWithJsonToString {
    private final HttpRequest httpRequest;
    private final Times times;
    private final TimeToLive timeToLive;
    private final HttpRequestMatcher httpRequestMatcher;
    private HttpResponse httpResponse;
    private HttpForward httpForward;
    private HttpError httpError;
    private HttpClassCallback httpClassCallback;
    private HttpObjectCallback httpObjectCallback;

    public Expectation(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        this.httpRequest = httpRequest;
        this.times = times;
        this.timeToLive = timeToLive;
        this.httpRequestMatcher = new MatcherBuilder().transformsToMatcher(this.httpRequest);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse(boolean applyDelay) {
        if (this.httpResponse != null) {
            if (applyDelay) {
                return this.httpResponse.applyDelay();
            }
            return this.httpResponse;
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public HttpForward getHttpForward() {
        return this.httpForward;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public HttpClassCallback getHttpClassCallback() {
        return this.httpClassCallback;
    }

    public HttpObjectCallback getHttpObjectCallback() {
        return this.httpObjectCallback;
    }

    public Action getAction(boolean applyDelay) {
        if (this.httpResponse != null) {
            return this.getHttpResponse(applyDelay);
        }
        if (this.httpForward != null) {
            return this.getHttpForward();
        }
        if (this.httpError != null) {
            return this.getHttpError();
        }
        if (this.httpClassCallback != null) {
            return this.getHttpClassCallback();
        }
        if (this.httpObjectCallback != null) {
            return this.getHttpObjectCallback();
        }
        return null;
    }

    public Times getTimes() {
        return this.times;
    }

    public TimeToLive getTimeToLive() {
        return this.timeToLive;
    }

    public Expectation thenRespond(HttpResponse httpResponse) {
        if (httpResponse != null) {
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a response once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response once an object callback has been set");
            }
            this.httpResponse = httpResponse;
        }
        return this;
    }

    public Expectation thenForward(HttpForward httpForward) {
        if (httpForward != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once an error has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once an object callback has been set");
            }
            this.httpForward = httpForward;
        }
        return this;
    }

    public Expectation thenError(HttpError httpError) {
        if (httpError != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set an error once a response has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set an error once a forward has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a error once a class callback has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a error once an object callback has been set");
            }
            this.httpError = httpError;
        }
        return this;
    }

    public Expectation thenCallback(HttpClassCallback httpClassCallback) {
        if (httpClassCallback != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once a response has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once an error has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once a forward has been set");
            }
            if (this.httpObjectCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a class callback once an object callback has been set");
            }
            this.httpClassCallback = httpClassCallback;
        }
        return this;
    }

    public Expectation thenCallback(HttpObjectCallback httpObjectCallback) {
        if (httpObjectCallback != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a object callback once a response has been set");
            }
            if (this.httpError != null) {
                throw new IllegalArgumentException("It is not possible to set a object callback once an error has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a object callback once a forward has been set");
            }
            if (this.httpClassCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a object callback once an class callback has been set");
            }
            this.httpObjectCallback = httpObjectCallback;
        }
        return this;
    }

    public boolean matches(HttpRequest httpRequest) {
        return this.hasRemainingMatches() && this.isStillAlive() && this.httpRequestMatcher.matches(httpRequest, true);
    }

    public boolean hasRemainingMatches() {
        return this.times == null || this.times.greaterThenZero();
    }

    @JsonIgnore
    public boolean isStillAlive() {
        return this.timeToLive == null || this.timeToLive.stillAlive();
    }

    public void decrementRemainingMatches() {
        if (this.times != null) {
            this.times.decrement();
        }
    }

    public void setNotUnlimitedResponses() {
        if (this.times != null) {
            this.times.setNotUnlimitedResponses();
        }
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }
}

