/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.services.daas.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.TemplateEngineUtils;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.ehealth.technicalconnector.validator.ValidatorHelper;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import be.fgov.ehealth.daas.complextype.v1.Actor;
import be.fgov.ehealth.technicalconnector.services.SAMLUtils;
import be.fgov.ehealth.technicalconnector.services.daas.AttributeValue;
import be.fgov.ehealth.technicalconnector.services.daas.DaasServiceException;
import be.fgov.ehealth.technicalconnector.services.daas.DataAttributeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.SOAPException;
import org.apache.commons.lang.RandomStringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataAttributeServiceImpl
implements DataAttributeService {
    private static final Logger LOG = LoggerFactory.getLogger(DataAttributeServiceImpl.class);
    private static final String SAML_ATTRIBUTE = "Attribute";
    private static final String ASSERTION_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:assertion";
    private static final String SAML_ATTRIBUTE_NAME = "Name";
    private static final String SCHEMA_FILE_LOCATION = "/ehealth-daasattribute/XSD/ehealth-daasattribute-1_0.xsd";
    private static final String TEMPLATES_DAAS_XML = "/templates/daas.attributequery.xml";
    private JAXBContext jaxbContext = JaxbContextFactory.getJaxbContextForPackage((Package)Actor.class.getPackage());

    @Override
    public Map<String, List<AttributeValue>> invoke(Map<String, List<String>> attributes) throws TechnicalConnectorException {
        DateTime notBefore = new DateTime().withTimeAtStartOfDay();
        DateTime notOnOrAfter = new DateTime().withTimeAtStartOfDay().plusDays(1).minusSeconds(1);
        return this.invoke(attributes, notBefore, notOnOrAfter);
    }

    @Override
    public Map<String, List<AttributeValue>> invoke(Map<String, List<String>> attributes, DateTime notBefore, DateTime notOnOrAfter) throws TechnicalConnectorException {
        GenericRequest request = new GenericRequest();
        request.setPayload(this.generatePayload(attributes, notBefore, notOnOrAfter));
        request.setCredentialFromSession(TokenType.SAML);
        request.addDefaulHandlerChain();
        request.setEndpoint(ConfigFactory.getConfigValidator().getProperty("endpoint.daas.v1", "$uddi{uddi:ehealth-fgov-be:business:dataattributeservice:v1}"));
        try {
            Element response = (Element)ServiceFactory.getGenericWsSender().send(request).asNode();
            this.validate(response);
            return this.map(response);
        }
        catch (SOAPException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, new Object[]{e.getMessage(), e});
        }
    }

    private String generatePayload(Map<String, List<String>> attributes, DateTime notBefore, DateTime notOnOrAfter) throws TechnicalConnectorException {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("attributeQueryId", "_" + IdGeneratorFactory.getIdGenerator((String)"uuid").generateId().substring(1));
        ctx.put("issuer", this.determineIssuer());
        ctx.put("issueInstant", DateUtils.printDateTime((DateTime)new DateTime().withZone(DateTimeZone.UTC)));
        ctx.put("transientNameId", RandomStringUtils.random((int)37, (boolean)false, (boolean)true));
        ctx.put("notBefore", DateUtils.printDateTime((DateTime)notBefore.withZone(DateTimeZone.UTC)));
        ctx.put("notOnOrAfter", DateUtils.printDateTime((DateTime)notOnOrAfter.withZone(DateTimeZone.UTC)));
        ctx.put("attrMap", attributes);
        return ConnectorXmlUtils.flatten((String)TemplateEngineUtils.generate(ctx, (String)TEMPLATES_DAAS_XML));
    }

    private void validate(Element response) throws TechnicalConnectorException {
        this.validateResponse(response);
        SAMLUtils.validateAssertions(response);
    }

    private void validateResponse(Element response) throws DaasServiceException {
        String status = SAMLUtils.getStatusCode(response);
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(SAMLUtils.getStatusCode(response))) {
            throw new DaasServiceException(status, SAMLUtils.getStatusMessage(response));
        }
    }

    private Map<String, List<AttributeValue>> map(Element response) {
        NodeList attributeList = response.getElementsByTagNameNS(ASSERTION_NAMESPACE, SAML_ATTRIBUTE);
        HashMap<String, List<AttributeValue>> result = new HashMap<String, List<AttributeValue>>();
        for (int i = 0; i < attributeList.getLength(); ++i) {
            Node node = attributeList.item(i);
            String attributeName = node.getAttributes().getNamedItem(SAML_ATTRIBUTE_NAME).getTextContent();
            if (node.hasChildNodes()) {
                NodeList attributeValueNodeList = node.getChildNodes();
                ArrayList<AttributeValue> values = new ArrayList<AttributeValue>();
                for (int index = 0; index < attributeValueNodeList.getLength(); ++index) {
                    NodeList attributeValues = attributeValueNodeList.item(index).getChildNodes();
                    for (int j = 0; j < attributeValues.getLength(); ++j) {
                        AttributeValue attrValue = this.convert(attributeValues.item(j));
                        if (attrValue == null) continue;
                        values.add(attrValue);
                    }
                }
                result.put(attributeName, values);
                continue;
            }
            result.put(attributeName, null);
        }
        return result;
    }

    private AttributeValue convert(Node value) {
        if (value.getNodeType() == 3) {
            return new AttributeValue(value.getTextContent().trim());
        }
        if (value.getNodeType() == 1) {
            try {
                Object object = this.jaxbContext.createUnmarshaller().unmarshal(value);
                ValidatorHelper.validate((Object)object, (String)SCHEMA_FILE_LOCATION);
                return new AttributeValue(object);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unrecognised object [{}], adding as node", (Object)DataAttributeServiceImpl.toString(value), (Object)e);
                }
                return new AttributeValue(value);
            }
        }
        LOG.debug("Ignoring node. Unsupported node type " + value.getNodeType());
        return null;
    }

    private String determineIssuer() {
        try {
            Map.Entry firstEntry;
            List attributeValues;
            Map matchingAttributes = SessionUtil.getMatchingAttributes((String)".*:certificateholder:.*");
            if (matchingAttributes.size() == 1 && (attributeValues = (List)(firstEntry = matchingAttributes.entrySet().iterator().next()).getValue()).size() == 1) {
                return (String)firstEntry.getKey() + ":" + (String)((List)firstEntry.getValue()).get(0);
            }
        }
        catch (TechnicalConnectorException e) {
            LOG.warn("Exception while extracting issuer from session.", (Throwable)e);
        }
        LOG.info("Returning default issuer.");
        return "urn:be:fgov:ehealth:unknown";
    }

    private static String toString(Node value) {
        String nodeAsString = null;
        try {
            nodeAsString = ConnectorXmlUtils.toString((Node)value);
        }
        catch (TechnicalConnectorException e1) {
            nodeAsString = "unknown";
        }
        return nodeAsString;
    }
}

