/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.schematron.impl;

import be.fgov.ehealth.schematron.SchematronSession;
import be.fgov.ehealth.schematron.domain.SchematronConfig;
import be.fgov.ehealth.schematron.domain.SchematronResult;
import be.fgov.ehealth.schematron.exception.InitialisationException;
import be.fgov.ehealth.schematron.utils.ValidatorErrorListener;
import be.fgov.ehealth.schematron.validator.Validator;
import be.fgov.ehealth.schematron.validator.ValidatorFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchematronSessionImpl
implements SchematronSession {
    private static final Logger LOG = LoggerFactory.getLogger(SchematronSessionImpl.class);
    private SchematronConfig config;
    private Validator validator;
    private File input;

    public SchematronSessionImpl(SchematronConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File convert(InputStream is) throws IOException {
        File temp = File.createTempFile("schematron", ".tmp");
        temp.deleteOnExit();
        FileWriter fileWriter = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileWriter = new FileWriter(temp);
            inputStreamReader = new InputStreamReader(is);
            IOUtils.copy((Reader)inputStreamReader, (Writer)fileWriter);
            fileWriter.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        IOUtils.closeQuietly((Reader)inputStreamReader);
        return temp;
    }

    @Override
    public SchematronResult validate(InputStream is) throws Exception {
        this.initValidator();
        this.input = SchematronSessionImpl.convert(is);
        return this.doValidate(new StreamSource(new FileInputStream(this.input)));
    }

    private void initValidator() throws InitialisationException {
        try {
            ValidatorFactory factory = new ValidatorFactory(this.config.getQueryLanguageBinding(), this.config.getFormat());
            if (this.config.getResolver() != null && !this.config.getResolver().isEmpty()) {
                factory.setResolver(this.loadClass(this.config.getResolver()));
            }
            factory.setDebugMode(this.config.isDebugMode());
            factory.setErrorListener(new ValidatorErrorListener());
            this.setParamOnFactory(factory, "phase", this.config.getPhase());
            this.setParamOnFactory(factory, "allow-foreign", this.config.getAllowForeign());
            this.setParamOnFactory(factory, "sch.exslt.imports", this.config.getSchExlstImports());
            this.setParamOnFactory(factory, "message-newline", this.config.getMessageNewline());
            this.setParamOnFactory(factory, "attributes", this.config.getAttributes());
            this.setParamOnFactory(factory, "only-child-elements", this.config.getonlyChildElements());
            this.setParamOnFactory(factory, "visit-text", this.config.getVisitText());
            this.setParamOnFactory(factory, "select-contents", this.config.getSelectContents());
            this.setParamOnFactory(factory, "generate-paths", this.config.getGeneratePaths());
            this.setParamOnFactory(factory, "diagnose", this.config.getDiagnose());
            this.setParamOnFactory(factory, "terminate", this.config.getTerminate());
            this.setParamOnFactory(factory, "schema-id", this.config.getSchemaId());
            this.setParamOnFactory(factory, "output-encoding", this.config.getEncoding());
            this.setParamOnFactory(factory, "langCode", this.config.getLangCode());
            LOG.info("Generating validator for schema " + this.config.getSchema() + "... ");
            this.validator = factory.newValidator(new StreamSource(this.config.getSchema()));
            LOG.info("Validator ready to process");
        }
        catch (TransformerException ex) {
            LOG.debug(ex.getMessage());
            SourceLocator locator = ex.getLocator();
            if (locator != null) {
                LOG.debug("SystemID: " + locator.getSystemId() + "; Line#: " + locator.getLineNumber() + "; Column#: " + locator.getColumnNumber());
            }
            throw new InitialisationException("The validator could not be initialised", ex);
        }
        catch (IOException io) {
            throw new InitialisationException("Error when outputting preprocessor stylesheet:", io);
        }
        catch (Exception e) {
            LOG.error("Error with initializing validator: " + e.getMessage());
            throw new InitialisationException("Error with initializing validator: ", e);
        }
    }

    private SchematronResult doValidate(StreamSource xmlSource) throws Exception {
        try {
            SchematronResult validate = this.validator.validate(xmlSource, this.config.getFileNameParameter(), this.config.getFileDirParameter(), this.config.getArchiveNameParameter(), this.config.getArchiveDirParameter(), this.config.getEncoding());
            validate.setInput(this.input);
            return validate;
        }
        catch (TransformerConfigurationException ex) {
            throw new Exception("Could not instantiate validator for document ");
        }
        catch (TransformerException ex) {
            if (this.config.isFailOnError()) {
                throw new Exception("Could not validate document ", ex);
            }
            LOG.error("", (Throwable)ex);
            SourceLocator locator = ex.getLocator();
            if (locator != null) {
                LOG.info("SystemID: " + locator.getSystemId() + "; Line#: " + locator.getLineNumber() + "; Column#: " + locator.getColumnNumber());
            }
            return null;
        }
    }

    private Class<?> loadClass(String classname) throws ClassNotFoundException {
        return Class.forName(classname);
    }

    private void setParamOnFactory(ValidatorFactory factory, String paramName, Object paramValue) {
        if (paramValue != null) {
            factory.setParameter(paramName, paramValue);
        }
    }
}

