package be.fgov.ehealth.technicalconnector.bootstrap.bcp.verifier;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.impl.ConfigurationFake;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;

public class StatusPageSignatureVerifierTest {

    @BeforeClass
    public static void before() {
        LoggingUtils.bootstrap("DEBUG");
    }

    private void setUp(String keyStoreDir) throws Exception {
        Configuration config = new ConfigurationFake();
        config.setProperty("KEYSTORE_DIR", keyStoreDir);
        config.setProperty("CAKEYSTORE_LOCATION", "caCertificateKeystore.jks");
        config.setProperty("CAKEYSTORE_PASSWORD", "system");

        ConfigFactory.setConfiguration(config);
    }

    @Test
    public void acceptance_v1() throws Exception {
        setUp("/P12/acc/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

    @Test
    public void production_v1() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

    @Test
    public void acceptance_v2() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }


    @Test
    public void production_v2() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

}