/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.builders.impl;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.util.ConfigReader;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * @author Priscilla Colleaux
 * @author EH076 Bart Van Haute
 * 
 */
public class ConfigReaderTest {

    @BeforeClass
    public static void initializeConfig() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.therlink.test.properties", false);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Session.getInstance().unloadSession();
    }


    @Test
    public void testReadFromSession() throws Exception {
        final HcParty careProvider = ConfigReader.getCareProvider();
        assertNotNull(careProvider);
        assertFalse(careProvider.getIds().isEmpty());
    }
}
