/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.beid.impl;

import be.ehealth.technicalconnector.beid.BeIDCardAdaptor;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.impl.beid.BeIDConnectorGuiFactory;
import be.ehealth.technicalconnector.service.sts.security.impl.beid.BeIDLogger;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.BeIDCards;
import be.fedict.commons.eid.client.CancelledException;
import be.fedict.commons.eid.client.spi.BeIDCardUI;
import be.fedict.commons.eid.client.spi.BeIDCardsUI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsEidAdaptor
implements BeIDCardAdaptor {
    public static final String PROP_BEID_CON_GUI = "beidcardsgui.class";
    private static ConfigurableFactoryHelper<BeIDCardsUI> helper = new ConfigurableFactoryHelper("beidcardsgui.class", null);
    private static final Logger LOG = LoggerFactory.getLogger(CommonsEidAdaptor.class);

    @Override
    public BeIDCard getBeIDCard() throws TechnicalConnectorException {
        BeIDCard beIDCard;
        BeIDCardUI beIDCardGui = CommonsEidAdaptor.getBeIDCardUI();
        BeIDCardsUI beIDCardsGui = CommonsEidAdaptor.getBeIDCardsUI();
        BeIDCards beIDCards = null;
        beIDCards = beIDCardsGui != null ? new BeIDCards((be.fedict.commons.eid.client.spi.Logger)new BeIDLogger(), beIDCardsGui) : new BeIDCards((be.fedict.commons.eid.client.spi.Logger)new BeIDLogger());
        if (!beIDCards.hasBeIDCards()) {
            LOG.error("No beIDCard found");
            ConnectorIOUtils.closeQuietly((Object)beIDCards);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_EID_NULL, new Object[0]);
        }
        try {
            beIDCard = beIDCards.getOneBeIDCard();
            if (beIDCardGui != null) {
                beIDCard.setUI(beIDCardGui);
            }
        }
        catch (CancelledException e) {
            ConnectorIOUtils.closeQuietly((Object)beIDCards);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.BEID_ERROR, (Throwable)e, e.getMessage());
        }
        return beIDCard;
    }

    private static BeIDCardUI getBeIDCardUI() {
        try {
            return BeIDConnectorGuiFactory.getInstance();
        }
        catch (TechnicalConnectorException e) {
            LOG.error("TechnicalConnectorException while trying to create the BeIDCardUI " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static BeIDCardsUI getBeIDCardsUI() {
        try {
            return helper.getImplementation(new HashMap<String, Object>(), false, true);
        }
        catch (TechnicalConnectorException e) {
            LOG.error("TechnicalConnectorException while trying to create the BeIDCardsUI " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

