/*
 * Copyright (c) eHealth
 */

package be.fgov.ehealth.technicalconnector.tests.junit.rule;

import org.junit.rules.ExternalResource;

import be.ehealth.technicalconnector.beid.BeIDCardAdaptor;
import be.ehealth.technicalconnector.beid.BeIDCardFactory;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.technicalconnector.tests.beid.DummyBeIDAdaptor;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;

/**
 * @author EHP
 */
public class BeIDInfoRule extends ExternalResource {

    public static SelectorStep activateEid() {
        return new InnerStep();
    }

    public static interface SelectorStep {
        public NameSelectorStep withName();

        public BeIDInfoRule basedOn(String location);

        public BeIDInfoRule build();
    }


    public static interface NameSelectorStep {
        public BeIDInfoRule Alice();

        public BeIDInfoRule Caroline();
    }

    private static String name;

    private BeIDInfoRule() {
        super();
    }

    private static class InnerStep implements NameSelectorStep, SelectorStep {

        @Override
        public NameSelectorStep withName() {
            return this;
        }

        @Override
        public BeIDInfoRule Alice() {
            return basedOn("/beid/Alice.xml");
        }

        @Override
        public BeIDInfoRule Caroline() {
            return basedOn("/beid/Caroline.xml");
        }

        @Override
        public BeIDInfoRule build() {
            return new BeIDInfoRule();
        }

        @Override
        public BeIDInfoRule basedOn(String location) {
            return build().withLocation(location);
        }

    }

    public BeIDInfoRule withLocation(String location) {
        ConfigFactory.getConfigValidator().setProperty(DummyBeIDAdaptor.LOCATION, location);
        return this;
    }

    @Override
    protected void before() throws Throwable {
        LoggingUtils.bootstrap();
        ConfigFactory.getConfigValidator().setProperty(BeIDCardFactory.PROP_BEID_ADAPTOR, DummyBeIDAdaptor.class.getName());

    }

    @Override
    protected void after() {
        ConfigFactory.getConfigValidator().setProperty(BeIDCardFactory.PROP_BEID_ADAPTOR, BeIDCardAdaptor.class.getName());
    }
}
