/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import be.fgov.ehealth.technicalconnector.signature.domain.XadesOption;


/**
 * tests the SignatureBuilder.
 *
 * @author EHP
 */
public class XadesBesSignatureTest extends AbstractSignatureTest {

    private static final Logger LOG = LoggerFactory.getLogger(XadesBesSignatureTest.class);

    @BeforeClass
    public static void initBuilder() throws Exception {
        builder = SignatureBuilderFactory.getSignatureBuilder(AdvancedElectronicSignatureEnumeration.XAdES);
    }

    @Test
    public void testBuildXadesBes() throws Exception {
        byte[] generatedXadesBes = generateXadesBes();
        LOG.debug(new String(generatedXadesBes));
        Assert.assertNotNull(generatedXadesBes);
        Assert.assertTrue(generatedXadesBes.length > 0);
    }

    private byte[] generateXadesBes() throws Exception {
        Map<String, Object> options = new HashMap<String, Object>();
        List<String> tranforms = new ArrayList<String>();
        tranforms.add("http://www.w3.org/2000/09/xmldsig#base64");
        options.put(XadesOption.TRANSFORMERLIST, tranforms);
        options.put(XadesOption.BASEURI, "_82403f5e-8f31-4b6f-a0ef-c76d60cc2f13");
        return builder.sign(credential, textToSign, options);
    }

    @Test
    public void testValidateGeneratedXadesBes() throws Exception {
        verifyXades(generateXadesBes(), textToSign);
    }

    @Test
    public void alteredXadesBes() throws Exception {
        verifyXades(generateXadesBes(), textToSign_bis, SignatureVerificationError.SIGNATURE_COULD_NOT_BE_VERIFIED);
    }

    @Override
    String getVerificationTemplate() {
        return "/result/expected/xades.bes.xml";
    }
}
