/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.geninsasync.session;

import be.cin.nip.async.business.GenericResponseList;
import be.ehealth.businessconnector.genericasync.helper.GetAndConfirmTestHelper;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.apache.commons.collections.CollectionUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;

import static org.junit.Assert.assertTrue;

/**
 * <p>Tests to check and document the asynchronous call flow of the operations get and confirm of the MediPrima invoicing service.<p>
 * 
 * <p>Not that the MediPrima service works with message id references (not with hashes).</p>
 * 
 * <p>The business content of the returned invoicing files is not checked.</p>
 *
 * @author EHP
 */
public class GenInsGetAndConfirmGenericAsyncIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(GenInsGetAndConfirmGenericAsyncIntegrationTest.class);

    private static final String PROJECT_NAME = "genins";
    private static final String OUTPUT_FILE_EXTENSION = ".txt";
    private static final String OUTPUT_DIR = "geninsSendFiles";
    private static final int MAX_MESSAGES = 100;

    private final List<String> messageNames = Arrays.asList("INSX","INSX-INTERM");

    private GetAndConfirmTestHelper testHelper;

    @Rule
    public SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.geninsasync.test.properties").build();

    
    @Before
    public void initTestHelper() throws ConnectorException {
        testHelper = GetAndConfirmTestHelper.Builder()
                .projectName(PROJECT_NAME)
                .messageNames(messageNames)
                .maxMessages(MAX_MESSAGES)
                .outputFileExtension(OUTPUT_FILE_EXTENSION)
                .outputDir(OUTPUT_DIR)
                .BusinessResponseValidator(new GetAndConfirmTestHelper.BusinessResponseValidator() {
                    @Override
                    public void validate(String blobValue) throws Exception {
                        GenericResponseList genericResponseList = ConnectorXmlUtils.toObject(blobValue, GenericResponseList.class);
                        ConnectorXmlUtils.dump(genericResponseList);
                        assertTrue("Business reponse should contain at least one genericResponse", genericResponseList != null && CollectionUtils.isNotEmpty(genericResponseList.getGenericResponses()));
                    }
                })
                .build();
    }
    
    @Test
    public void getTest() throws Exception {
        testHelper.performGetAndConfirm(false);
    }

    @Test
    public void getAndConfirmTest() throws Exception {
        testHelper.performGetAndConfirm(true);
    }


    /**
     * To run this test, supply a list of TAckResponse references you want ensure they are no longer returned
     * by the service (typically, after confirming TAck responses).
     */
    @Test
    public void checkIfTAckResponsesWithSameReferencesAreStillReturned() throws Exception {

        // Add your own references to be verified
        List<String> tAckResponseReferences = Arrays.asList();

        testHelper.checkIfTAckResponsesWithSameReferencesAreStillReturned(tAckResponseReferences);
    }

    @Test
    public void checkIfMessagesWithSameReferencesAreStillReturned() throws Exception {

        // Add your own references to be verified
        List<String> msgResponseReferences = Arrays.asList();

        testHelper.checkIfMessagesWithSameReferencesAreStillReturned(msgResponseReferences);
    }
}
