/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import be.fgov.ehealth.etee.crypto.policies.EncryptionCredential;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class EncryptionCredentials {
    private EncryptionCredentials() {
    }

    public static EncryptionCredential[] from(Map<String, PrivateKey> privateKeyMap) {
        ArrayList<EncryptionCredential> credentials = new ArrayList<EncryptionCredential>();
        if (privateKeyMap == null || privateKeyMap.isEmpty()) {
            return credentials.toArray(new EncryptionCredential[credentials.size()]);
        }
        for (Map.Entry<String, PrivateKey> entry : privateKeyMap.entrySet()) {
            credentials.add(EncryptionCredential.create(entry.getValue(), entry.getKey()));
        }
        return credentials.toArray(new EncryptionCredential[credentials.size()]);
    }

    public static Map<String, PrivateKey> toMap(EncryptionCredential[] credentials) {
        if (credentials == null || credentials.length == 0) {
            return null;
        }
        HashMap<String, PrivateKey> map = new HashMap<String, PrivateKey>();
        for (EncryptionCredential credential : credentials) {
            map.put(credential.getEncryptionTokenSerialNumber(), credential.getPrivateKey());
        }
        return map;
    }
}

