﻿/*
 * Copyright (c) eHealth
 */
using System;
using NUnit.Framework;

namespace be.ehealth.businessconnector.ehbox.v3.util
{
    [TestFixture]
    public class QualityMapper
    {
        public static QualityMapper GROUP = new QualityMapper("group", "GROUP", "NIHII");

        public static QualityMapper PERPHYSICIAN = new QualityMapper("persphysician", "DOCTOR", "INSS");
        
        public static QualityMapper PERSNURSE = new QualityMapper("persnurse", "NURSE", "INSS");
        
        public static QualityMapper PERDENTIST = new QualityMapper("persdentist", "DENTIST", "INSS");
        
        public static QualityMapper PHARMACY = new QualityMapper("pharmacy", "PHARMACIST", "INSS");
        
        public static QualityMapper PHYSIOTHERAPIST = new QualityMapper("physiotherapist", "PHYSIOTHERAPIST", "INSS");
        
        public static QualityMapper DEPTPHARMACY = new QualityMapper("deptpharmacy", "PHARMACY", "NIHII");

        
        private string quality;

        private string type;
        
        private string professioType;
        
        private static java.util.Map mapper;
        
        
        static QualityMapper() {
            mapper = new java.util.HashMap();
            mapper.put(GROUP.professioType, GROUP);
            mapper.put(PERPHYSICIAN.professioType, PERPHYSICIAN);
            mapper.put(PERSNURSE.professioType, PERSNURSE);
            mapper.put(PERDENTIST.professioType, PERDENTIST);
            mapper.put(PHARMACY.professioType, PHARMACY);
            mapper.put(PHYSIOTHERAPIST.professioType, PHYSIOTHERAPIST);
            mapper.put(DEPTPHARMACY.professioType, DEPTPHARMACY);
        }
        
        public static QualityMapper getMapper(string professionType) {
            if (mapper.containsKey(professionType)) {
                return (QualityMapper)mapper.get(professionType);
            } else {
                return null;
            }
        }
        
        /**
         * @param quality
         * @param type
         */
        private QualityMapper(string professioType, string quality, string type) {
            this.professioType = professioType;
            this.quality = quality;
            this.type = type;
        }
        
        /**
         * @return the quality
         */
        public string getQuality() {
            return quality;
        }
        
        /**
         * @return the type
         */
        public string getType() {
            return type;
        }
    }
}
