/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetdomaincommons.builders.impl;

import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.impl.BuilderUtils;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.exception.InvalidBlobContentConnectorException;
import be.ehealth.business.mycarenetdomaincommons.exception.InvalidBlobContentConnectorExceptionValues;
import be.ehealth.business.mycarenetdomaincommons.util.PropertyUtil;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.util.ArrayList;
import java.util.Map;

public class BlobBuilderImpl
implements BlobBuilder {
    private static final String PROPERTYBEGINNING = "mycarenet.blobbuilder.";
    private String projectName;

    public void initialize(Map<String, Object> parameterMap) throws TechnicalConnectorException {
        if (parameterMap == null || parameterMap.isEmpty() || !parameterMap.containsKey("projectName")) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.CORE_TECHNICAL, new Object[]{"missing config parameters for initialize of BlobBuilder , check factory method call"});
        }
        this.projectName = (String)parameterMap.get("projectName");
    }

    @Override
    public Blob build(byte[] input) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        String usedProjectName = this.getProjectPropertiesValue();
        String id = PROPERTYBEGINNING + usedProjectName + ".id";
        ConfigValidator validator = this.getProperties(id);
        return this.build(input, validator.getProperty(id));
    }

    @Override
    public Blob build(byte[] input, String id) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        String usedProjectName = this.getProjectPropertiesValue();
        String encodingType = PROPERTYBEGINNING + usedProjectName + ".encodingtype";
        String contentType = PROPERTYBEGINNING + usedProjectName + ".contenttype";
        ConfigValidator validator = this.getProperties(encodingType, contentType);
        return this.build(input, validator.getProperty(encodingType), id, validator.getProperty(contentType));
    }

    @Override
    public Blob build(byte[] input, String encodingType, String id, String contentType) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        return this.build(input, encodingType, id, contentType, null);
    }

    @Override
    public Blob build(byte[] input, String encodingType, String id, String contentType, String messageName) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        return this.build(input, encodingType, id, contentType, messageName, null);
    }

    @Override
    public Blob build(byte[] input, String encodingType, String id, String contentType, String messageName, String contentEncryption) throws InvalidBlobContentConnectorException, TechnicalConnectorException {
        if (input == null || input.length == 0) {
            throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.PARAMETER_NULL, null, "byte[] input");
        }
        if (contentType == null || contentType.isEmpty()) {
            throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.PARAMETER_NULL, null, "String contentType");
        }
        Blob newBlob = new Blob();
        newBlob.setContentEncoding("none");
        byte[] buff = input;
        if (encodingType.equals("deflate")) {
            newBlob.setContentEncoding(encodingType);
            buff = ConnectorIOUtils.compress((byte[])input, (String)"deflate");
        }
        newBlob.setContent(buff);
        newBlob.setContentType(contentType);
        newBlob.setId(id);
        newBlob.setMessageName(messageName);
        newBlob.setHashValue(null);
        newBlob.setContentEncryption(contentEncryption);
        return newBlob;
    }

    @Override
    public byte[] checkAndRetrieveContent(Blob blob) throws TechnicalConnectorException {
        if (blob == null) {
            throw new InvalidBlobContentConnectorException(InvalidBlobContentConnectorExceptionValues.PARAMETER_NULL, null, "Blob blob");
        }
        return BuilderUtils.checkAndDecompress(blob.getContent(), blob.getContentEncoding(), blob.getHashValue(), blob.isHashTagRequired());
    }

    private String getProjectPropertiesValue() {
        return PropertyUtil.retrieveProjectNameToUse(this.projectName, PROPERTYBEGINNING);
    }

    private ConfigValidator getProperties(String ... neededProperties) {
        ArrayList<String> expectedProps = new ArrayList<String>();
        for (String neededPropertie : neededProperties) {
            expectedProps.add(neededPropertie);
        }
        return ConfigFactory.getConfigValidator(expectedProps);
    }
}

