/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.cert;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.cert.CertPathCheckerResult;
import be.fgov.ehealth.etee.crypto.cert.CertificateStatus;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import be.fgov.ehealth.etee.crypto.utils.CertStringBuilder;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

class CertPathCheckerPKIX
implements CertPathChecker {
    private static final Logger LOGGER = Logger.getLogger(CertPathCheckerPKIX.class);
    private final KeyStore trustedCaCertificates;

    public CertPathCheckerPKIX(KeyStore trustedCaCertificates) {
        this.trustedCaCertificates = trustedCaCertificates;
    }

    @Override
    public CryptoResult<CertificateStatus> validate(List<X509Certificate> certificateChain) {
        return this.validate(certificateChain, null);
    }

    @Override
    public CryptoResult<CertificateStatus> validate(List<X509Certificate> certificateChain, Date validationDate) {
        Preconditions.checkNotEmpty(certificateChain, "No certificate chain present for checking.");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Checking trust in certificate chain [" + CertStringBuilder.build(certificateChain) + "]"));
        }
        try {
            return new CertPathCheckerResult(this.checkTrust(certificateChain, validationDate));
        }
        catch (CertPathValidatorException e) {
            return this.handleCertPathValidatorException(e);
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"The certificate chain could not be parsed to a certificate path.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"PKIX is not provided for cert path validation.", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error((Object)"Parameters are incorrect for cert path validation.", (Throwable)e);
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)"Keystore with Trusted CA certificates is not properly initialized", (Throwable)e);
        }
        return new CertPathCheckerResult(NotificationFatal.CERTIFICATION_PATH_CHECK_FAILED);
    }

    private CryptoResult<CertificateStatus> handleCertPathValidatorException(CertPathValidatorException e) {
        if (e.getCause() instanceof CertificateExpiredException) {
            LOGGER.warn((Object)("Cert chain NOT trusted (expired): " + e.getMessage()));
            return new CertPathCheckerResult(CertificateStatus.EXPIRED);
        }
        LOGGER.warn((Object)"Cert chain NOT trusted", (Throwable)e);
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Details of CertPartValidatorException: ");
            sb.append("Cause=").append(e.getCause());
            sb.append(", CertPath=").append(e.getCertPath());
            sb.append(", TrustStore=").append(CertStringBuilder.build(this.trustedCaCertificates));
            LOGGER.debug((Object)sb.toString());
        }
        return new CertPathCheckerResult(CertificateStatus.UNSPECIFIED);
    }

    private CertificateStatus checkTrust(List<X509Certificate> certificateChain, Date validationDate) throws CertificateException, NoSuchAlgorithmException, CertPathValidatorException, InvalidAlgorithmParameterException, KeyStoreException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            LOGGER.error((Object)("Cryptolib's default provider [BC] is not available as provider. Using platform default to generate CertPath. Detail: " + e.getMessage()), (Throwable)e);
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        CertPath certChain = certificateFactory.generateCertPath(certificateChain);
        return this.checkTrust(certChain, validationDate);
    }

    private CertificateStatus checkTrust(CertPath certificateChain, Date validationDate) throws NoSuchAlgorithmException, CertPathValidatorException, InvalidAlgorithmParameterException, KeyStoreException {
        LOGGER.debug((Object)"Checking trust in cert chain...");
        CertPath cp = certificateChain;
        PKIXParameters pkixp = new PKIXParameters(this.trustedCaCertificates);
        pkixp.setDate(validationDate);
        pkixp.setRevocationEnabled(false);
        CertPathValidator cpv = CertPathValidator.getInstance("PKIX");
        PKIXCertPathValidatorResult pkixResult = (PKIXCertPathValidatorResult)cpv.validate(cp, pkixp);
        if (pkixResult != null) {
            LOGGER.info((Object)"Certificatechain valid");
            if (pkixResult.getTrustAnchor().getTrustedCert() != null) {
                LOGGER.info((Object)("Certificatechain trusted from Anchor CA " + pkixResult.getTrustAnchor().getTrustedCert().getSubjectX500Principal()));
            }
            return CertificateStatus.VALID;
        }
        return CertificateStatus.UNSPECIFIED;
    }
}

