/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.dicsv2.validator;

import static org.junit.Assert.assertTrue;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import org.junit.Assert;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.dics.protocol.v2.FindAmpRequest;
import be.fgov.ehealth.dics.protocol.v2.FindAmpResponse;
import be.fgov.ehealth.dics.protocol.v2.FindCompanyRequest;
import be.fgov.ehealth.dics.protocol.v2.FindCompanyResponse;
import be.fgov.ehealth.dics.protocol.v2.FindLegislationTextRequest;
import be.fgov.ehealth.dics.protocol.v2.FindLegislationTextResponse;
import be.fgov.ehealth.dics.protocol.v2.FindReferencesRequest;
import be.fgov.ehealth.dics.protocol.v2.FindReferencesResponse;
import be.fgov.ehealth.dics.protocol.v2.FindReimbursementRequest;
import be.fgov.ehealth.dics.protocol.v2.FindReimbursementResponse;
import be.fgov.ehealth.dics.protocol.v2.FindVmpRequest;
import be.fgov.ehealth.dics.protocol.v2.FindVmpResponse;


/**
 * tests the class XmlValidator.
 * 
 * @author EH076
 * 
 * @since
 * 
 */
public class XmlValidatorTest {

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindAmpRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/request/findAmpRequest.xml");
        MarshallerHelper<FindAmpRequest, FindAmpRequest> helper = new MarshallerHelper<FindAmpRequest, FindAmpRequest>(FindAmpRequest.class, FindAmpRequest.class);
        FindAmpRequest xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindAmpResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/response/findAmpResponse.xml");
        MarshallerHelper<FindAmpResponse, FindAmpResponse> helper = new MarshallerHelper<FindAmpResponse, FindAmpResponse>(FindAmpResponse.class, FindAmpResponse.class);
        FindAmpResponse xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }
    
    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindCompanyRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/request/findCompanyRequest.xml");
        MarshallerHelper<FindCompanyRequest, FindCompanyRequest> helper = new MarshallerHelper<FindCompanyRequest, FindCompanyRequest>(FindCompanyRequest.class, FindCompanyRequest.class);
        FindCompanyRequest xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindCompanyResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/response/findCompanyResponse.xml");
        MarshallerHelper<FindCompanyResponse, FindCompanyResponse> helper = new MarshallerHelper<FindCompanyResponse, FindCompanyResponse>(FindCompanyResponse.class, FindCompanyResponse.class);
        FindCompanyResponse xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindLegislationTextRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/request/findLeglislationTextRequest.xml");
        MarshallerHelper<FindLegislationTextRequest, FindLegislationTextRequest> helper = new MarshallerHelper<FindLegislationTextRequest, FindLegislationTextRequest>(FindLegislationTextRequest.class, FindLegislationTextRequest.class);
        FindLegislationTextRequest xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindLegislationTextResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/response/findLeglislationTextResponse.xml");
        MarshallerHelper<FindLegislationTextResponse, FindLegislationTextResponse> helper = new MarshallerHelper<FindLegislationTextResponse, FindLegislationTextResponse>(FindLegislationTextResponse.class, FindLegislationTextResponse.class);
        FindLegislationTextResponse xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindReferencesRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/request/findReferencesRequest.xml");
        MarshallerHelper<FindReferencesRequest, FindReferencesRequest> helper = new MarshallerHelper<FindReferencesRequest, FindReferencesRequest>(FindReferencesRequest.class, FindReferencesRequest.class);
        FindReferencesRequest xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindReferencesResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/response/findReferencesResponse.xml");
        MarshallerHelper<FindReferencesResponse, FindReferencesResponse> helper = new MarshallerHelper<FindReferencesResponse, FindReferencesResponse>(FindReferencesResponse.class, FindReferencesResponse.class);
        FindReferencesResponse xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindReimbursementRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/request/findReimboursementRequest.xml");
        MarshallerHelper<FindReimbursementRequest, FindReimbursementRequest> helper = new MarshallerHelper<FindReimbursementRequest, FindReimbursementRequest>(FindReimbursementRequest.class, FindReimbursementRequest.class);
        FindReimbursementRequest xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindReimbursementResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/response/findReimboursementResponse.xml");
        MarshallerHelper<FindReimbursementResponse, FindReimbursementResponse> helper = new MarshallerHelper<FindReimbursementResponse, FindReimbursementResponse>(FindReimbursementResponse.class, FindReimbursementResponse.class);
        FindReimbursementResponse xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindVmpRequest() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/request/findVmpRequest.xml");
        MarshallerHelper<FindVmpRequest, FindVmpRequest> helper = new MarshallerHelper<FindVmpRequest, FindVmpRequest>(FindVmpRequest.class, FindVmpRequest.class);
        FindVmpRequest xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dicsv2.validator.XmlValidator#validateXml(java.lang.Object)}.
     */
    @Test
    public void testValidateFindVmpResponse() throws TechnicalConnectorException, FileNotFoundException {
        String path = ConnectorIOUtils.getResourceFilePath("/response/findVmpResponse.xml");
        MarshallerHelper<FindVmpResponse, FindVmpResponse> helper = new MarshallerHelper<FindVmpResponse, FindVmpResponse>(FindVmpResponse.class, FindVmpResponse.class);
        FindVmpResponse xmlObject = helper.toObject(new FileInputStream(path));
        
        XmlValidator.validateXml(xmlObject);
    }


    @Test
    public void testConstructorIsPrivate() throws Exception {
        Constructor<XmlValidator> constructor = XmlValidator.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
            UnsupportedOperationException usoe = (UnsupportedOperationException) e.getTargetException();
            Assert.assertEquals("class may not be initialized, only static methods should be used", usoe.getMessage());
        }
    }
}
