/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.IdentifierType;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateParser {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateParser.class);
    private static final String OU_EHP = "eHealth-platform Belgium";
    private static final String OU_FEDERAL_GOVERNMENT = "Federal Government";
    private static final String ORGANIZATION_UNIT_NAME_ATTRIBUTE_TYPE = "OU";
    private static final String COMMON_NAME_ATTRIBUTE_TYPE = "CN";
    private static final String SERIALNUMBER_OID_ATTRIBUTE_TYPE = BCStyle.SN.getId();
    private static final String NO_VALUE = "";
    private String type = "";
    private String id = "";
    private String application = "";

    public CertificateParser(X509Certificate cert) throws TechnicalConnectorException {
        this(cert.getSubjectX500Principal().getName("RFC2253"));
    }

    public CertificateParser(String subject) throws TechnicalConnectorException {
        LdapName name = null;
        try {
            name = new LdapName(subject);
        }
        catch (InvalidNameException e) {
            LOG.error(TechnicalConnectorExceptionValues.INVALID_CERTIFICATE.getMessage(), (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.INVALID_CERTIFICATE, (Throwable)e, new Object[0]);
        }
        List<Rdn> rdnList = name.getRdns();
        ArrayList<String> ouList = new ArrayList<String>();
        ArrayList<String> cnList = new ArrayList<String>();
        for (Rdn rdn : rdnList) {
            if (rdn.getType().equals(ORGANIZATION_UNIT_NAME_ATTRIBUTE_TYPE)) {
                ouList.add(this.getValue(rdn.getValue()));
            }
            if (rdn.getType().equals(COMMON_NAME_ATTRIBUTE_TYPE)) {
                cnList.add(this.getValue(rdn.getValue()));
            }
            if (!rdn.getType().equals(SERIALNUMBER_OID_ATTRIBUTE_TYPE)) continue;
            this.type = IdentifierType.SSIN.getType(48);
            this.id = this.getValue(rdn.getValue());
            break;
        }
        if (!StringUtils.isEmpty((String)this.id)) {
            return;
        }
        for (String ou : ouList) {
            LOG.debug("Analysing OU:" + ou);
            if (Pattern.matches("([A-Z(-|_)]+=[0-9]+)", ou)) {
                String[] splittedOU = ou.split("=");
                this.id = splittedOU[1];
                this.type = splittedOU[0];
                continue;
            }
            if (ouList.size() < 4 || ou.equals(OU_FEDERAL_GOVERNMENT) || ou.equals(OU_EHP)) continue;
            LOG.info("ApplicationId is present");
            if (((String)cnList.get(0)).indexOf(ou) < 0) continue;
            this.application = ou;
        }
    }

    private String getValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            return this.convertToString((byte[])value);
        }
        LOG.error("Unsupported value [" + value.getClass() + "]");
        return NO_VALUE;
    }

    private String convertToString(byte[] value) {
        try {
            ASN1Primitive content = ASN1Primitive.fromByteArray((byte[])value);
            if (content instanceof DERPrintableString) {
                return ((DERPrintableString)content).getString();
            }
            LOG.error("Unsupported ASN1Object :" + content.getClass());
        }
        catch (Exception e) {
            LOG.error("Error while converting to String", (Throwable)e);
        }
        return NO_VALUE;
    }

    public final String getType() {
        return this.type;
    }

    @Deprecated
    public final String getValue() {
        return this.id;
    }

    public final String getApplication() {
        return this.application;
    }

    public final IdentifierType getIdentifier() {
        return IdentifierType.lookup(this.type, null, 48);
    }

    public final String getId() {
        return this.id;
    }
}

