/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.easymock.ConstructorArgs;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.easymock.IMocksControl;
import org.easymock.internal.AndroidClassProxyFactory;
import org.easymock.internal.AndroidSupport;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.ClassProxyFactory;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.JavaProxyFactory;
import org.easymock.internal.LastControl;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.MocksBehavior;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.ReplayState;
import org.easymock.internal.RuntimeExceptionWrapper;

public class MocksControl
implements IMocksControl,
IExpectationSetters<Object>,
Serializable {
    private static final long serialVersionUID = 443604921336702014L;
    public static final Range ONCE = new Range(1);
    public static final Range AT_LEAST_ONCE = new Range(1, Integer.MAX_VALUE);
    public static final Range ZERO_OR_MORE = new Range(0, Integer.MAX_VALUE);
    private static IProxyFactory classProxyFactory;
    private static final IProxyFactory interfaceProxyFactory;
    private IMocksControlState state;
    private IMocksBehavior behavior;
    private org.easymock.MockType type;

    public MocksControl(org.easymock.MockType type) {
        this.type = type;
        this.reset();
    }

    public MocksControl(MockType type) {
        this.type = type.realType;
        this.reset();
    }

    public org.easymock.MockType getType() {
        return this.type;
    }

    public IMocksControlState getState() {
        return this.state;
    }

    @Override
    public <T> T createMock(Class<T> toMock) {
        return this.createMock(null, toMock, null, null);
    }

    @Override
    public <T> T createMock(String name, Class<T> toMock) {
        return this.createMock(name, toMock, null, null);
    }

    @Override
    public <T> T createMock(String name, Class<T> toMock, ConstructorArgs constructorArgs, Method ... mockedMethods) {
        if (toMock == null) {
            throw new NullPointerException("Can't mock 'null'");
        }
        if (toMock.isInterface() && mockedMethods != null) {
            throw new IllegalArgumentException("Partial mocking doesn't make sense for interface");
        }
        try {
            this.state.assertRecordState();
            IProxyFactory proxyFactory = toMock.isInterface() ? interfaceProxyFactory : MocksControl.getClassProxyFactory();
            try {
                return proxyFactory.createProxy(toMock, new ObjectMethodsFilter(toMock, new MockInvocationHandler(this), name), mockedMethods, constructorArgs);
            }
            catch (NoClassDefFoundError e) {
                if (e.getMessage().startsWith("org/objenesis")) {
                    throw new RuntimeExceptionWrapper(new RuntimeException("Class mocking requires to have Objenesis library in the classpath", e));
                }
                throw e;
            }
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public static IProxyFactory getProxyFactory(Object o) {
        return Proxy.isProxyClass(o.getClass()) ? new JavaProxyFactory() : MocksControl.getClassProxyFactory();
    }

    private static IProxyFactory getClassProxyFactory() {
        String classMockingDisabled = EasyMockProperties.getInstance().getProperty("easymock.disableClassMocking");
        if (Boolean.valueOf(classMockingDisabled).booleanValue()) {
            throw new IllegalArgumentException("Class mocking is currently disabled. Change easymock.disableClassMocking to true do modify this behavior");
        }
        IProxyFactory cached = classProxyFactory;
        if (cached != null) {
            return cached;
        }
        if (AndroidSupport.isAndroid()) {
            classProxyFactory = new AndroidClassProxyFactory();
            return classProxyFactory;
        }
        classProxyFactory = new ClassProxyFactory();
        return classProxyFactory;
    }

    public static MocksControl getControl(Object mock) {
        try {
            IProxyFactory factory = MocksControl.getProxyFactory(mock);
            ObjectMethodsFilter handler = (ObjectMethodsFilter)factory.getInvocationHandler(mock);
            return handler.getDelegate().getControl();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a mock: " + mock.getClass().getName());
        }
    }

    public static InvocationHandler getInvocationHandler(Object mock) {
        return MocksControl.getClassProxyFactory().getInvocationHandler(mock);
    }

    public static <T, R extends T> Class<R> getMockedClass(T proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return proxy.getClass().getInterfaces()[0];
        }
        return proxy.getClass().getSuperclass();
    }

    @Deprecated
    public static <T, R extends T> Class<R> getMockedType(T proxy) {
        return MocksControl.getMockedClass(proxy);
    }

    @Override
    public void reset() {
        this.behavior = new MocksBehavior(this.type == org.easymock.MockType.NICE);
        this.behavior.checkOrder(this.type == org.easymock.MockType.STRICT);
        this.state = new RecordState(this.behavior);
        LastControl.reportLastControl(null);
    }

    @Override
    public void resetToNice() {
        this.type = org.easymock.MockType.NICE;
        this.reset();
    }

    @Override
    public void resetToDefault() {
        this.type = org.easymock.MockType.DEFAULT;
        this.reset();
    }

    @Override
    public void resetToStrict() {
        this.type = org.easymock.MockType.STRICT;
        this.reset();
    }

    @Override
    public void replay() {
        try {
            this.state.replay();
            this.state = new ReplayState(this.behavior);
            LastControl.reportLastControl(null);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void verifyRecording() {
        try {
            this.state.verifyRecording();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper e) {
            throw (AssertionError)((Object)((Throwable)((Object)e.getAssertionError())).fillInStackTrace());
        }
    }

    @Override
    public void verifyUnexpectedCalls() {
        try {
            this.state.verifyUnexpectedCalls();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper e) {
            throw (AssertionError)((Object)((Throwable)((Object)e.getAssertionError())).fillInStackTrace());
        }
    }

    @Override
    public void verify() {
        try {
            this.state.verify();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionErrorWrapper e) {
            throw (AssertionError)((Object)((Throwable)((Object)e.getAssertionError())).fillInStackTrace());
        }
    }

    @Override
    public void checkOrder(boolean value) {
        try {
            this.state.checkOrder(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void makeThreadSafe(boolean threadSafe) {
        try {
            this.state.makeThreadSafe(threadSafe);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void checkIsUsedInOneThread(boolean shouldBeUsedInOneThread) {
        try {
            this.state.checkIsUsedInOneThread(shouldBeUsedInOneThread);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andReturn(Object value) {
        try {
            this.state.andReturn(value);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andThrow(Throwable throwable) {
        try {
            this.state.andThrow(throwable);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andAnswer(IAnswer<? extends Object> answer) {
        try {
            this.state.andAnswer(answer);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andDelegateTo(Object answer) {
        try {
            this.state.andDelegateTo(answer);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> andVoid() {
        try {
            this.state.andVoid();
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubReturn(Object value) {
        try {
            this.state.andStubReturn(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubThrow(Throwable throwable) {
        try {
            this.state.andStubThrow(throwable);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubAnswer(IAnswer<? extends Object> answer) {
        try {
            this.state.andStubAnswer(answer);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void andStubDelegateTo(Object delegateTo) {
        try {
            this.state.andStubDelegateTo(delegateTo);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public void asStub() {
        try {
            this.state.asStub();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> times(int times) {
        try {
            this.state.times(new Range(times));
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> times(int min, int max) {
        try {
            this.state.times(new Range(min, max));
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> once() {
        try {
            this.state.times(ONCE);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> atLeastOnce() {
        try {
            this.state.times(AT_LEAST_ONCE);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    @Override
    public IExpectationSetters<Object> anyTimes() {
        try {
            this.state.times(ZERO_OR_MORE);
            return this;
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    static {
        interfaceProxyFactory = new JavaProxyFactory();
    }

    @Deprecated
    public static enum MockType {
        NICE(org.easymock.MockType.NICE),
        DEFAULT(org.easymock.MockType.DEFAULT),
        STRICT(org.easymock.MockType.STRICT);

        private org.easymock.MockType realType;

        private MockType(org.easymock.MockType realType) {
            this.realType = realType;
        }

        public org.easymock.MockType getRealType() {
            return this.realType;
        }
    }
}

