/*
 * Copyright (c) eHealth
 */

using be.fgov.ehealth.hubservices.core.v2;
using NUnit.Framework;

/**
 * integration test for the wsconsent connector. will test some scenarios.
 * 
 * @author EHP
 */
namespace be.ehealth.businessconnector.wsconsent.service
{
	/// <summary>
	/// Description of TestUtils.
	/// </summary>
	public class WsConsentServiceUserIntegrationTest : AbstractWsConsentServiceIntegrationTest {
	
	
	    [Test]
	    public void testPutPatientConsent() {
	        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
	        PutPatientConsentResponse response = putConsentForCurrentPatient(consentType);
	        
	        Assert.IsNotNull(response);
	        Assert.IsNotNull(response.getAcknowledge());
	        Assert.IsNotNull(response.getResponse());
	
	        java.util.List errors = response.getAcknowledge().getErrors();
	        Assert.IsTrue( errors.isEmpty(), "Errors returned in the acknowledge");
	        
	        revokePatientconsent(consentType);
	    }
	
	
	    [Test]
	    public void testGetPatientConsent() {
	        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
	        putConsentForCurrentPatient(consentType);
	        
	        GetPatientConsentResponse response = retrievePatientConsentResponse();
	        Assert.IsNotNull(response);
	        
	        Assert.IsTrue(response.getAcknowledge().isIscomplete());
	        java.util.List errors = response.getAcknowledge().getErrors();
	        Assert.IsTrue( errors.isEmpty(), "Errors returned in the acknowledge");
	        
	        revokePatientconsent(consentType);
	    }
	    
	    [Test]
	    public void testGetPatientConsentStatus() {
		    ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
		    putConsentForCurrentPatient(consentType);
		
		    GetPatientConsentStatusResponse response = retrievePatientConsentStatusResponse();
		    Assert.IsNotNull(response);
		
		    Assert.IsTrue(response.getAcknowledge().isIscomplete());
		    java.util.List errors = response.getAcknowledge().getErrors();
		    Assert.IsTrue(errors.isEmpty(), "Errors returned in the acknowledge");
		    Assert.IsTrue(response.getConsent().getStatus() == StatusType.GIVEN);
		    
		    revokePatientconsent(consentType);
		
		    response = retrievePatientConsentStatusResponse();
		    Assert.IsNotNull(response);
		
		    Assert.IsTrue(response.getAcknowledge().isIscomplete());
		    errors = response.getAcknowledge().getErrors();
		    Assert.IsTrue(errors.isEmpty(), "Errors returned in the acknowledge");
		    Assert.IsTrue(response.getConsent().getStatus() == StatusType.REVOKED);
		}
	
	
	    [Test]
	    public void testRevokePatientConsent() {
	        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
	        putConsentForCurrentPatient(consentType);
	        
	        RevokePatientConsentResponse response = revokePatientconsent(consentType);
	        Assert.IsNotNull(response);
	        Assert.IsNotNull(response.getAcknowledge());
	        Assert.IsNotNull(response.getResponse());
	        
	        Assert.IsTrue(response.getAcknowledge().isIscomplete());
	        java.util.List errors = response.getAcknowledge().getErrors();
	        Assert.IsTrue( errors.isEmpty(), "Errors returned in the acknowledge");
	    }
	
	
	    [Test]
	    public void testPutPatientConsentWithSessionService() {
	        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
	        PutPatientConsentResponse response = putConsentForCurrentPatientWithSessionService(consentType);
	        Assert.IsNotNull(response);
	        Assert.IsNotNull(response.getAcknowledge());
	        Assert.IsNotNull(response.getResponse());
	
	        Assert.IsTrue(response.getAcknowledge().isIscomplete());
	        java.util.List errors = response.getAcknowledge().getErrors();
	        Assert.IsTrue( errors.isEmpty(), "Errors returned in the acknowledge");
	
	        revokePatientconsentWithSessionService(consentType);
	    }
	
	
	    [Test]
	    public void testGetPatientConsentWithSessionService() {
	        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
	        putConsentForCurrentPatientWithSessionService(consentType);
	
	        GetPatientConsentResponse response = retrievePatientConsentResponseWithSessionService();
	        Assert.IsNotNull(response);
	
	        Assert.IsTrue(response.getAcknowledge().isIscomplete());
	        java.util.List errors = response.getAcknowledge().getErrors();
	        Assert.IsTrue( errors.isEmpty(), "Errors returned in the acknowledge");
	        
	        revokePatientconsentWithSessionService(consentType);
	
	    }
	    
	    [Test]
	    public void testGetPatientConsentStatusWithSessionService() {
	    	ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
		    putConsentForCurrentPatientWithSessionService(consentType);
		
		    GetPatientConsentStatusResponse response = retrievePatientConsentStatusResponseWithSessionService();
		    Assert.IsNotNull(response);
		
		    Assert.IsTrue(response.getAcknowledge().isIscomplete());
		    java.util.List errors = response.getAcknowledge().getErrors();
		    Assert.IsTrue(errors.isEmpty(), "Errors returned in the acknowledge");
		    Assert.IsTrue(response.getConsent().getStatus() == StatusType.GIVEN);
		    
		    revokePatientconsentWithSessionService(consentType);
		
		    response = retrievePatientConsentStatusResponseWithSessionService();
		    Assert.IsNotNull(response);
		
		    Assert.IsTrue(response.getAcknowledge().isIscomplete());
		    errors = response.getAcknowledge().getErrors();
		    Assert.IsTrue(errors.isEmpty(), "Errors returned in the acknowledge");
		    Assert.IsTrue(response.getConsent().getStatus() == StatusType.REVOKED);
		}
	
	
	    [Test]
	    public void testRevokePatientConsentWithSessionService() {
	        ConsentType consentType = createNewConsentTypeForCurrentPatientAndAuthor();
	        putConsentForCurrentPatientWithSessionService(consentType);
	        
	        RevokePatientConsentResponse response = revokePatientconsentWithSessionService(consentType);
	        Assert.IsNotNull(response);
	        Assert.IsNotNull(response.getAcknowledge());
	        Assert.IsNotNull(response.getResponse());
	        
	        Assert.IsTrue(response.getAcknowledge().isIscomplete());
	        java.util.List errors = response.getAcknowledge().getErrors();
	        Assert.IsTrue( errors.isEmpty(), "Errors returned in the acknowledge");
	    }	
	}
}