package be.fgov.ehealth.technicalconnector.bootstrap.bcp.verifier;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.ConfigurationFakeRule;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.LoggingRule;

@Ignore
public class StatusPageSignatureVerifierTest {

    @ClassRule
    public static LoggingRule logging = LoggingRule.with().consoleAppender().build();

    @Rule
    public ConfigurationFakeRule configurationFakeRule = new ConfigurationFakeRule();

    private void setUp(String keyStoreDir) {
        configurationFakeRule.setProperty("KEYSTORE_DIR", keyStoreDir);
        configurationFakeRule.setProperty("CAKEYSTORE_LOCATION", "caCertificateKeystore.jks");
        configurationFakeRule.setProperty("CAKEYSTORE_PASSWORD", "system");

    }

    @Test
    public void acceptance_v1() throws Exception {
        setUp("/P12/acc/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

    @Test
    public void production_v1() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelist.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

    @Test
    public void acceptance_v2() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }


    @Test
    public void production_v2() throws Exception {
        setUp("/P12/prod/");

        String xml = ConnectorIOUtils.getResourceAsString("https://servicelist-acpt.ehealth.fgov.be/servicelistv2.xml");
        Assert.assertTrue(StatusPageSignatureVerifier.isValid(xml));
    }

}