/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.shutdown.DeleteFileOnExitShutdownHook;
import com.gc.iotools.stream.is.InputStreamFromOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorIOUtils {
    public static final String COMPRESSION_ALGO_DEFLATE = "deflate";
    public static final String COMPRESSION_ALGO_GZIP = "gz";
    private static final String BASE64_VALIDATOR_REGEX = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorIOUtils.class);
    private static CompressorStreamFactory factory = new CompressorStreamFactory();
    private static ArchiveStreamFactory asFactory = new ArchiveStreamFactory();

    private ConnectorIOUtils() {
        throw new UnsupportedOperationException();
    }

    public static byte[] getBytes(InputStream inputStream) throws TechnicalConnectorException {
        if (inputStream == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)inputStream);
        }
    }

    public static byte[] toBytes(String content, Charset charsetName) throws TechnicalConnectorException {
        byte[] bytes = null;
        if (content == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        if (charsetName == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        try {
            bytes = content.getBytes(charsetName.getName());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNSUPPORTED_ENCODING_EXCEPTION, (Throwable)e, e.getMessage());
        }
        return bytes;
    }

    public static String toString(byte[] message, Charset charsetName) throws TechnicalConnectorException {
        Validate.notNull((Object)message);
        Validate.notNull((Object)((Object)charsetName));
        try {
            return new String(message, charsetName.getName());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to convert input.", (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNSUPPORTED_ENCODING_EXCEPTION, (Throwable)e, e.getMessage());
        }
    }

    public static byte[] compress(byte[] input) throws TechnicalConnectorException {
        return ConnectorIOUtils.compress(input, COMPRESSION_ALGO_GZIP);
    }

    public static void compress(InputStream in, OutputStream out, String algo) throws TechnicalConnectorException {
        CompressorOutputStream gzippedOut;
        DeflaterInputStream compressedInputStream;
        block5: {
            compressedInputStream = null;
            gzippedOut = null;
            try {
                if (COMPRESSION_ALGO_DEFLATE.equalsIgnoreCase(algo)) {
                    compressedInputStream = new DeflaterInputStream(in, new Deflater(-1, true));
                    IOUtils.copy((InputStream)compressedInputStream, (OutputStream)out);
                    break block5;
                }
                gzippedOut = factory.createCompressorOutputStream(algo, out);
                IOUtils.copy((InputStream)in, (OutputStream)gzippedOut);
            }
            catch (Exception e) {
                try {
                    LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, new Object[0]);
                }
                catch (Throwable throwable) {
                    ConnectorIOUtils.closeQuietly(compressedInputStream, gzippedOut);
                    throw throwable;
                }
            }
        }
        ConnectorIOUtils.closeQuietly(compressedInputStream, gzippedOut);
    }

    public static byte[] compress(byte[] input, String algo) throws TechnicalConnectorException {
        byte[] byArray;
        if (ArrayUtils.isEmpty((byte[])input) || StringUtils.isEmpty((CharSequence)algo)) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            out = new ByteArrayOutputStream();
            ConnectorIOUtils.compress(in, (OutputStream)out, algo);
            out.flush();
            byArray = out.toByteArray();
        }
        catch (IOException e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(in, out);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly(in, out);
        return byArray;
    }

    public static void decompress(InputStream in, OutputStream out, boolean noWrap) throws TechnicalConnectorException {
        InflaterOutputStream decompressed = null;
        try {
            decompressed = new InflaterOutputStream(out, new Inflater(noWrap));
            IOUtils.copy((InputStream)in, (OutputStream)decompressed);
        }
        catch (Exception e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(decompressed);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)decompressed);
    }

    public static byte[] decompress(byte[] input) throws TechnicalConnectorException {
        byte[] byArray;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            byArray = ConnectorIOUtils.getBytes(ConnectorIOUtils.decompress(in));
        }
        catch (Throwable throwable) {
            ConnectorIOUtils.closeQuietly(in);
            throw throwable;
        }
        ConnectorIOUtils.closeQuietly((Object)in);
        return byArray;
    }

    public static InputStream decompress(InputStream input) throws TechnicalConnectorException {
        Validate.notNull((Object)input);
        BufferedInputStream is = new BufferedInputStream(input);
        is.mark(1024);
        try {
            InputStream result = ConnectorIOUtils.compressorInputStream(is);
            if (result != null) {
                return result;
            }
            is.reset();
            result = ConnectorIOUtils.archiveInputStream(is);
            if (result != null) {
                return result;
            }
            is.reset();
            result = ConnectorIOUtils.deflate(is, true);
            if (result != null) {
                return result;
            }
            result = ConnectorIOUtils.deflate(is, false);
            if (result != null) {
                return result;
            }
            is.reset();
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, e.getMessage());
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, "Unsupported compression algorithm.");
    }

    private static InputStream compressorInputStream(InputStream is) {
        try {
            LOG.debug("Using createCompressorInputStream");
            return factory.createCompressorInputStream(is);
        }
        catch (Exception e) {
            LOG.debug("[CompressionFactory]   " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return null;
        }
    }

    private static InputStream archiveInputStream(InputStream is) {
        try {
            LOG.debug("Using createArchiveInputStream");
            return asFactory.createArchiveInputStream(is);
        }
        catch (Exception e) {
            LOG.debug("[ArchiveStreamFactory] " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return null;
        }
    }

    private static InputStream deflate(InputStream is, boolean noWrap) {
        try {
            LOG.debug("Using deflater noWrap={}", (Object)noWrap);
            return ConnectorIOUtils.deflater(is, noWrap);
        }
        catch (Exception e) {
            LOG.debug("[Deflater noWrap={}] {}: {}", new Object[]{noWrap, e.getClass().getSimpleName(), e.getMessage()});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream deflater(final InputStream is, final boolean noWrap) throws Exception {
        AutoDeleteFileInputStream autoDeleteFileInputStream;
        InputStreamFromOutputStream<Void> result = new InputStreamFromOutputStream<Void>(){

            protected Void produce(OutputStream sink) throws Exception {
                ConnectorIOUtils.decompress(is, sink, noWrap);
                return null;
            }
        };
        FileOutputStream fos = null;
        try {
            File temp = File.createTempFile("connector-io-", ".tmp");
            fos = new FileOutputStream(temp);
            IOUtils.copy((InputStream)result, (OutputStream)fos);
            autoDeleteFileInputStream = new AutoDeleteFileInputStream(temp);
        }
        catch (Throwable throwable) {
            ConnectorIOUtils.closeQuietly(fos, result);
            throw throwable;
        }
        ConnectorIOUtils.closeQuietly(fos, result);
        return autoDeleteFileInputStream;
    }

    public static InputStream getResourceAsStream(String location) throws TechnicalConnectorException {
        return ConnectorIOUtils.getResourceAsStream(location, true);
    }

    public static String getResourceAsString(String location) throws TechnicalConnectorException {
        return ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(location));
    }

    public static byte[] getResourceAsByteArray(String location) throws TechnicalConnectorException {
        return ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream(location));
    }

    public static InputStream getResourceAsStream(String location, boolean bootstrap) throws TechnicalConnectorException {
        if (location == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        LOG.debug("Loading [{}] as ResourceAsStream.", (Object)location);
        InputStream stream = ConnectorIOUtils.class.getResourceAsStream(location);
        if (stream == null) {
            File file = new File(location);
            if (!file.exists()) {
                try {
                    LOG.debug("Loading [{}] as URL.", (Object)location);
                    if (bootstrap) {
                        ConfigFactory.getConfigValidator().getConfig();
                    }
                    URL resource = new URL(location);
                    return resource.openStream();
                }
                catch (Exception e) {
                    LOG.error("Location [{}] could not be retrieved as URL, classpath resource or file.", (Object)location);
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, location);
                }
            }
            try {
                LOG.debug("Loading [{}] as FileInputStream.", (Object)location);
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                LOG.error("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, location);
            }
        }
        return stream;
    }

    public static File getResourceAsFile(String location) throws TechnicalConnectorException {
        File file;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            File tempFile = File.createTempFile("connector-io", ".tmp");
            DeleteFileOnExitShutdownHook.deleteOnExit(tempFile);
            tempFile.deleteOnExit();
            out = new FileOutputStream(tempFile);
            in = ConnectorIOUtils.getResourceAsStream(location);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, location);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(in, out);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly(in, out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceFilePath(String location) throws TechnicalConnectorException {
        String filePath;
        block8: {
            if (location == null) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
            }
            filePath = null;
            LOG.debug("Loading {} as ResourceAsString", (Object)location);
            InputStream stream = null;
            try {
                stream = ConnectorIOUtils.class.getResourceAsStream(location);
                if (stream != null) {
                    LOG.debug("Location found as Resource.");
                    filePath = ConnectorIOUtils.class.getResource(location).getFile();
                    break block8;
                }
                File file = new File(location);
                if (!file.exists()) {
                    try {
                        URL resource = new URL(location);
                        filePath = resource.getFile();
                        LOG.debug("Location found as URL.");
                        break block8;
                    }
                    catch (MalformedURLException e) {
                        LOG.error("location [{}] could not be retrieved as URL, classpath resource or file.", (Object)location);
                        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, "location ]" + location + "[ errorMessage :" + e.getMessage());
                    }
                }
                LOG.debug("Location found as File.");
                filePath = location;
            }
            finally {
                ConnectorIOUtils.closeQuietly((Object)stream);
            }
        }
        return filePath;
    }

    public static String convertStreamToString(InputStream is) throws TechnicalConnectorException {
        String result;
        if (is == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        try {
            result = IOUtils.toString((InputStream)is, (String)Charset.UTF_8.getName());
        }
        catch (IOException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
        return result;
    }

    public static void closeQuietly(Object closeable) {
        try {
            if (closeable != null) {
                Method closeMethod = closeable.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke(closeable, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Object ... closeables) {
        for (Object closeable : closeables) {
            ConnectorIOUtils.closeQuietly(closeable);
        }
    }

    public static byte[] base64Decode(byte[] input, boolean recursive) throws TechnicalConnectorException {
        byte[] result = ArrayUtils.clone((byte[])input);
        String content = ConnectorIOUtils.toString(result, Charset.UTF_8);
        if (content.matches(BASE64_VALIDATOR_REGEX)) {
            result = Base64.getDecoder().decode(result);
            if (recursive) {
                result = ConnectorIOUtils.base64Decode(result, recursive);
            }
        }
        return result;
    }

    public static File createTempFile(String name) throws TechnicalConnectorException {
        return ConnectorIOUtils.createTempFile(name, true);
    }

    public static String getTempFileLocation(String name) throws TechnicalConnectorException {
        return ConnectorIOUtils.createTempFile(name, false).getPath();
    }

    public static File createTempFile(String name, boolean create) throws TechnicalConnectorException {
        if (name == null || name.isEmpty()) {
            LOG.error("The name given for the tempFile is empty");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, "The name given for the tempFile is empty");
        }
        String tempDirectory = System.getProperty("java.io.tmpdir");
        if (tempDirectory == null || tempDirectory.isEmpty()) {
            LOG.error("The property 'java.io.tmpdir' not found in the system properties");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "The property 'java.io.tmpdir' not found in the system properties");
        }
        File tempFile = new File(tempDirectory, name);
        if (create) {
            try {
                tempFile.getParentFile().mkdirs();
                if (tempFile.createNewFile()) {
                    return tempFile;
                }
            }
            catch (IOException e) {
                LOG.error("IOException while creating temporary file {}", (Object)tempFile.getPath());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, e.getMessage(), e, "creating temporary file" + tempFile.getPath());
            }
        }
        return tempFile;
    }

    private static class AutoDeleteFileInputStream
    extends FileInputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(AutoDeleteFileInputStream.class);
        private File file;
        private boolean isClosed;
        private boolean isDeleted;

        public AutoDeleteFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
            DeleteFileOnExitShutdownHook.deleteOnExit(file);
        }

        @Override
        public void close() {
            if (this.isClosed) {
                LOGGER.debug("stream already closed");
                return;
            }
            LOGGER.debug("closing stream :{}", (Object)this.file);
            this.isClosed = true;
            try {
                super.close();
                this.isDeleted = this.file.delete();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close stream: {}", (Object)this, (Object)e);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to delete underlying file: {}", (Object)this.file, (Object)e);
            }
            LOGGER.debug("close()- file [{}] deleted: {}", (Object)this.file, (Object)this.isDeleted);
        }
    }
}

