﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.service.etee;
using be.ehealth.technicalconnector.service.keydepot;
using be.ehealth.technicalconnector.service.keydepot.impl;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.ehbox.consultation.protocol.v3;
using be.fgov.ehealth.ehbox.core.v3;
using java.lang;
using NUnit.Framework;
using org.easymock;

namespace be.ehealth.businessconnector.ehbox.v3.builders.impl
{

    /**
     * Test class for {@link ConsultationMessageBuilderImpl}.
     * 
     * @author EHP
     * 
     */
    public class ConsultationFullMessageBuilderTest
{    
        private ConsultationFullMessageBuilder builder;
    
        private Crypto crypto;
    
        private KeyDepotService keydepotService;
    
        /**
         * @throws java.lang.Exception
         */
        [SetUp]
        public void setUp() {
    
            crypto = (Crypto) EasyMock.createMock(typeof(Crypto));
            keydepotService =(KeyDepotService) EasyMock.createMock(typeof(KeyDepotService));
            builder = new ConsultationFullMessageBuilder(crypto);
    
        }
    
        /**
         * Reinitialise the KeyDepotService.
         * 
         * @throws Exception
         */
        [TearDown]
        public static void tearDown() {
            KeyDepotManagerFactory.getKeyDepotManager().setKeyDepotService((KeyDepotService) new KeyDepotServiceImpl());
        }
    
        [Test]
        public void testIssueEhconext169() {
            byte[] bytes = ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream(".\\examples/getMessageListResponse.xml"));
            MarshallerHelper helper = new MarshallerHelper(typeof(GetMessagesListResponse),typeof(GetMessagesListResponse));
            GetMessagesListResponse response = (GetMessagesListResponse) helper.toObject(bytes);
            Assert.NotNull(response);
            Assert.NotNull(response.getMessages());
            Assert.AreEqual(18, response.getMessages().size());
            for (int i=0; i<response.getMessages().size();i++){
                Message message = (Message) response.getMessages().get(i);
                bool isEncrypted = message.getContentSpecification().isIsEncrypted();
                be.ehealth.businessconnector.ehbox.api.domain.Message buildMessage = BuilderFactory.getConsultationMessageBuilder().buildMessage(message);
                bool encrypted = buildMessage.isEncrypted();
                Assert.AreEqual(isEncrypted, encrypted);
            }
        }
    }
}
