﻿using be.ehealth.businessconnector.mycarenet.attestv3.session;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.mycarenet.attestv3.builders;
using be.ehealth.business.mycarenetcommons.domain;
using be.ehealth.business.mycarenetcommons.v4.builders;
using be.ehealth.business.mycarenetcommons.security;
using be.ehealth.businessconnector.test.testcommons.utils;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.businessconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.fgov.ehealth.technicalconnector.signature.domain;
using be.fgov.ehealth.messageservices.mycarenet.core.v1;
using be.fgov.ehealth.mycarenet.attest.protocol.v3;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using javax.xml.soap;
using javax.xml.ws.soap;
using java.io;
using java.util;
using org.joda.time;
using org.w3c.dom;

using NUnit.Framework;
using System;

namespace be.ehealth.businessconnector.mycarenet.attestv3.session
{
	
	public abstract class AbstractIntegrationTest {
	
    	private string emehID;
	
	    private string enxsID;
	
	    private string cmchID;
	
	    private string cnxsID;
    
		public AbstractIntegrationTest(string emehID, string enxsID, string cmchID, string cnxsID) {
	        this.emehID = emehID;
	        this.enxsID = enxsID;
	        this.cmchID = cmchID;
	        this.cnxsID = cnxsID;
		}
	    
	    [Test]
        public void happySendAttestationWithEncryption() {
            happySendAttestationTest(emehID);
        }
        
        [Test]
        public void happyCancelAttestationWithoutEncryption() {
            happyCancelAttestationTest(cmchID);
        }
        
        [Test]
        public void unhappySendAttestationWithEncryption() {
            unhappySendAttestationTest(enxsID);
        }
      
        [Test]
        public void unhappyCancelAttestationWithoutEncryption() {
            unhappyCancelAttestationTest(cnxsID);
        }
        
        private void happySendAttestationTest(String inputReference) {
        	byte[] kmehrmessage = System.Text.Encoding.UTF8.GetBytes(ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\attestv3\\requests\\mha-request-detail.xml"));
        
            SignedEncryptedResponseHolder attestResponse = sendAttestation(inputReference, kmehrmessage);
    
            SignatureVerificationResult signatureVerificationResult = attestResponse.getSignatureVerificationResult();
            Assert.IsTrue(signatureVerificationResult.isValid(), "Errors found in the signature verification");
            String expectedResponse = ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\attestv3\\responses\\mha-response-detail-" + inputReference + ".xml");
            be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expectedResponse, System.Text.Encoding.UTF8.GetString(attestResponse.getBusinessResponse()));
        }
    
        private void happyCancelAttestationTest(String inputReference) {
            byte[] kmehrmessage = System.Text.Encoding.UTF8.GetBytes(ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\attestv3\\requests\\mhca-request-detail.xml"));
    
            SignedResponseHolder attestResponse = cancelAttestation(inputReference, kmehrmessage);
    
            SignatureVerificationResult signatureVerificationResult = attestResponse.getSignatureVerificationResult();
            Assert.IsTrue(signatureVerificationResult.isValid(), "Errors found in the signature verification");
            String expectedResponse = ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\attestv3\\responses\\mhca-response-detail-" + inputReference + ".xml");
            be.fgov.ehealth.businessconnector.tests.utils.XmlAsserter.assertSimilar(expectedResponse, System.Text.Encoding.UTF8.GetString(attestResponse.getBusinessResponse()));
        }
    
        private void unhappySendAttestationTest(String inputReference) {
            byte[] kmehrmessage = System.Text.Encoding.UTF8.GetBytes(ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\attestv3\\requests\\ns-request-detail.xml"));
            try {
                sendAttestation(inputReference, kmehrmessage);
                Assert.Fail("soap fault expected");
            } catch (SOAPFaultException sfe) {
                checkSOAPFault(sfe, "EMPTY_BLOB", "Blob is empty.");
            }
        }
    
        private void unhappyCancelAttestationTest(String inputReference) {
            byte[] kmehrmessage = System.Text.Encoding.UTF8.GetBytes(ConnectorIOUtils.getResourceAsString(".\\examples\\mycarenet\\attestv3\\requests\\ns-cancel-request-detail.xml"));
            try {
                cancelAttestation(inputReference, kmehrmessage);
                Assert.Fail("soap fault expected");
            } catch (SOAPFaultException sfe) {
                checkSOAPFault(sfe, "INVALID_DETAIL_REQUEST", "Detail XML structure is not valid against schema.");
            }
        }
    
        private SignedEncryptedResponseHolder sendAttestation(String inputReference, byte[] kmehrmessage) {
             EncryptedRequestHolder attestBuilderRequest = (EncryptedRequestHolder) RequestObjectBuilderFactory.getRequestObjectBuilder().buildSendAttestationRequest(
                    SendAttestationRequestInput.builder()
                            .isTest(true)
                            .inputReference(new InputReference(inputReference))
                            .kmehrmessage(kmehrmessage)
                            .patientSsin(new Ssin("72070539942"))
                            .referenceDate(LocalDateTime.now())
                            .messageVersion("3.0")
                            .issuer("some issuer")
                            .commonInputAttributes(Arrays.asList(
                                be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                    .key("urn:be:cin:nippin:purpose")
                                    .value("some purpose")
                                    .build(),
                                be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                    .key("urn:be:cin:nippin:attemptNbr")
                                    .value(new java.lang.Integer("1"))
                                    .build()))
                            .build());
                    
            SendAttestationResponse sendAttestationResponse = AttestSessionServiceFactory.getAttestService().sendAttestation(attestBuilderRequest.getSendAttestationRequest());
    
            return ResponseObjectBuilderFactory.getResponseObjectBuilder().handleSendAttestionResponse(sendAttestationResponse, attestBuilderRequest);
        }
    
        private SignedResponseHolder cancelAttestation(String inputReference, byte[] kmehrmessage) {
            CancelAttestationRequest cancelAttestationRequest = (CancelAttestationRequest) RequestObjectBuilderFactory.getRequestObjectBuilder().buildCancelAttestationRequest(
                    CancelAttestationRequestInput.builder()
                            .isTest(true)
                            .inputReference(new InputReference(inputReference))
                            .kmehrmessage(kmehrmessage)
                            .messageVersion("3.0")
                            .issuer("some issuer")
                            .commonInputAttributes(Arrays.asList(
                                be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                    .key("urn:be:cin:nippin:purpose")
                                    .value("some purpose")
                                    .build(),
                                be.ehealth.business.mycarenetdomaincommons.domain.Attribute.builder()
                                    .key("urn:be:cin:nippin:attemptNbr")
                                    .value(new java.lang.Integer("1"))
                                    .build()))
                            .build());
                            
            CancelAttestationResponse cancelAttestationResponse = AttestSessionServiceFactory.getAttestService().cancelAttestation(cancelAttestationRequest);
    
            return ResponseObjectBuilderFactory.getResponseObjectBuilder().handleCancelAttestationResponse(cancelAttestationResponse, cancelAttestationRequest);
        }
	
	    private void checkSOAPFault(SOAPFaultException sfe, String expectedErrorCode, String expectedMessage) {
	        java.util.List entries = new ArrayList();
	        Iterator it = sfe.getFault().getDetail().getDetailEntries();
	        while (it.hasNext()) entries.add((DetailEntry) it.next());
	
	        Assert.IsTrue(entries.size() == 1);
	
	        MarshallerHelper helper = new MarshallerHelper(typeof(BusinessError), typeof(BusinessError));
	        BusinessError error = (BusinessError) helper.toObject((org.w3c.dom.Node) entries.get(0));
	
	        Assert.IsTrue(expectedErrorCode.Equals(error.getCode()));
	        Assert.IsTrue("MYCARENET".Equals(error.getOrigin()));
	
	        java.util.List messages = error.getMessages();
	        Assert.IsTrue(messages.size() == 1);
	
	        LocalisedStringType message = (LocalisedStringType)messages.get(0);
	        Assert.IsTrue(expectedMessage.Equals(message.getValue()));
	    }
	}
}
