/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.easymock.TestSubject;
import org.powermock.api.extension.listener.AnnotationGlobalMetadata;
import org.powermock.api.extension.listener.MockMetadata;
import org.powermock.reflect.Whitebox;

class TestSubjectInjector {
    private final Object testInstance;
    private final AnnotationGlobalMetadata globalMetadata;

    public TestSubjectInjector(Object testInstance, AnnotationGlobalMetadata globalMetadata) {
        this.testInstance = testInstance;
        this.globalMetadata = globalMetadata;
    }

    protected void injectTestSubjectMocks() throws IllegalAccessException {
        Set testSubjectFields = Whitebox.getFieldsAnnotatedWith((Object)this.testInstance, TestSubject.class, (Class[])new Class[0]);
        for (Field testSubjectField : testSubjectFields) {
            Object testSubject = testSubjectField.get(this.testInstance);
            if (testSubject == null) {
                throw new NullPointerException("Have you forgotten to instantiate " + testSubjectField.getName() + "?");
            }
            this.injectTestSubjectFields(testSubject);
        }
    }

    protected void injectTestSubjectFields(Object testSubject) throws IllegalAccessException {
        Set<Field> targetFields = new HashSet<Field>(Whitebox.getAllInstanceFields((Object)testSubject));
        targetFields = this.injectByName(targetFields, testSubject);
        this.injectByType(targetFields, testSubject);
    }

    void injectByType(Set<Field> targetFields, Object testSubject) throws IllegalAccessException {
        for (Field targetField : targetFields) {
            InjectionTarget target = new InjectionTarget(targetField);
            MockMetadata toAssign = this.findUniqueAssignable(target);
            if (toAssign == null) continue;
            target.inject(testSubject, toAssign);
        }
    }

    MockMetadata findUniqueAssignable(InjectionTarget target) {
        MockMetadata toAssign = null;
        for (MockMetadata mockMetadata : this.globalMetadata.getUnqualifiedInjections()) {
            if (!target.accepts(mockMetadata)) continue;
            if (toAssign != null) {
                throw new RuntimeException(String.format("At least two mocks can be assigned to '%s': %s and %s", target.getField(), toAssign.getMock(), mockMetadata.getMock()));
            }
            toAssign = mockMetadata;
        }
        return toAssign;
    }

    Set<Field> injectByName(Set<Field> targetFields, Object targetObject) throws IllegalAccessException {
        Class<?> targetClass = targetObject.getClass();
        for (MockMetadata mockMetadata : this.globalMetadata.getQualifiedInjections()) {
            InjectionTarget target;
            Field targetField = this.getFieldByName(targetClass, mockMetadata.getQualifier());
            if (targetField == null || !(target = new InjectionTarget(targetField)).accepts(mockMetadata)) continue;
            target.inject(targetObject, mockMetadata);
            targetFields.remove(targetField);
        }
        return targetFields;
    }

    private Field getFieldByName(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static class InjectionTarget {
        private final Field field;

        public InjectionTarget(Field field) {
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        public boolean accepts(MockMetadata mockMetadata) {
            return this.field.getType().isAssignableFrom(mockMetadata.getType());
        }

        public void inject(Object targetObject, MockMetadata mockMetadata) throws IllegalAccessException {
            this.field.setAccessible(true);
            Object value = this.field.get(targetObject);
            if (value == null) {
                this.field.set(targetObject, mockMetadata.getMock());
            }
        }
    }
}

